/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.storage;

import java.util.Optional;

public class ProducerStateEntry {
    private Long producerId;
    private Short producerEpoch;
    private Integer coordinatorEpoch;
    private Long lastTimestamp;
    private Optional<Long> currentTxnFirstOffset;

    public boolean maybeUpdateProducerEpoch(Short producerEpoch) {
        if (!this.producerEpoch.equals(producerEpoch)) {
            this.producerEpoch = producerEpoch;
            return true;
        }
        return false;
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateProducerEpoch(nextEntry.producerEpoch);
        this.currentTxnFirstOffset(nextEntry.currentTxnFirstOffset);
        this.lastTimestamp(nextEntry.lastTimestamp);
    }

    public static ProducerStateEntry empty(Long producerId) {
        return new ProducerStateEntry(producerId, (short)-1, -1, -1L, Optional.empty());
    }

    public Long producerId() {
        return this.producerId;
    }

    public Short producerEpoch() {
        return this.producerEpoch;
    }

    public Integer coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public Long lastTimestamp() {
        return this.lastTimestamp;
    }

    public Optional<Long> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public ProducerStateEntry producerId(Long producerId) {
        this.producerId = producerId;
        return this;
    }

    public ProducerStateEntry producerEpoch(Short producerEpoch) {
        this.producerEpoch = producerEpoch;
        return this;
    }

    public ProducerStateEntry coordinatorEpoch(Integer coordinatorEpoch) {
        this.coordinatorEpoch = coordinatorEpoch;
        return this;
    }

    public ProducerStateEntry lastTimestamp(Long lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }

    public ProducerStateEntry currentTxnFirstOffset(Optional<Long> currentTxnFirstOffset) {
        this.currentTxnFirstOffset = currentTxnFirstOffset;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProducerStateEntry)) {
            return false;
        }
        ProducerStateEntry other = (ProducerStateEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$producerId = this.producerId();
        Long other$producerId = other.producerId();
        if (this$producerId == null ? other$producerId != null : !((Object)this$producerId).equals(other$producerId)) {
            return false;
        }
        Short this$producerEpoch = this.producerEpoch();
        Short other$producerEpoch = other.producerEpoch();
        if (this$producerEpoch == null ? other$producerEpoch != null : !((Object)this$producerEpoch).equals(other$producerEpoch)) {
            return false;
        }
        Integer this$coordinatorEpoch = this.coordinatorEpoch();
        Integer other$coordinatorEpoch = other.coordinatorEpoch();
        if (this$coordinatorEpoch == null ? other$coordinatorEpoch != null : !((Object)this$coordinatorEpoch).equals(other$coordinatorEpoch)) {
            return false;
        }
        Long this$lastTimestamp = this.lastTimestamp();
        Long other$lastTimestamp = other.lastTimestamp();
        if (this$lastTimestamp == null ? other$lastTimestamp != null : !((Object)this$lastTimestamp).equals(other$lastTimestamp)) {
            return false;
        }
        Optional<Long> this$currentTxnFirstOffset = this.currentTxnFirstOffset();
        Optional<Long> other$currentTxnFirstOffset = other.currentTxnFirstOffset();
        return !(this$currentTxnFirstOffset == null ? other$currentTxnFirstOffset != null : !((Object)this$currentTxnFirstOffset).equals(other$currentTxnFirstOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProducerStateEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $producerId = this.producerId();
        result = result * 59 + ($producerId == null ? 43 : ((Object)$producerId).hashCode());
        Short $producerEpoch = this.producerEpoch();
        result = result * 59 + ($producerEpoch == null ? 43 : ((Object)$producerEpoch).hashCode());
        Integer $coordinatorEpoch = this.coordinatorEpoch();
        result = result * 59 + ($coordinatorEpoch == null ? 43 : ((Object)$coordinatorEpoch).hashCode());
        Long $lastTimestamp = this.lastTimestamp();
        result = result * 59 + ($lastTimestamp == null ? 43 : ((Object)$lastTimestamp).hashCode());
        Optional<Long> $currentTxnFirstOffset = this.currentTxnFirstOffset();
        result = result * 59 + ($currentTxnFirstOffset == null ? 43 : ((Object)$currentTxnFirstOffset).hashCode());
        return result;
    }

    public String toString() {
        return "ProducerStateEntry(producerId=" + this.producerId() + ", producerEpoch=" + this.producerEpoch() + ", coordinatorEpoch=" + this.coordinatorEpoch() + ", lastTimestamp=" + this.lastTimestamp() + ", currentTxnFirstOffset=" + this.currentTxnFirstOffset() + ")";
    }

    public ProducerStateEntry(Long producerId, Short producerEpoch, Integer coordinatorEpoch, Long lastTimestamp, Optional<Long> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.lastTimestamp = lastTimestamp;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

