/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.util.FieldParser;

public final class ConfigurationUtils {
    public static <T extends PulsarConfiguration> T create(String configFile, Class<? extends PulsarConfiguration> clazz) throws IOException, IllegalArgumentException {
        Preconditions.checkNotNull((Object)configFile);
        return ConfigurationUtils.create(new FileInputStream(configFile), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PulsarConfiguration> T create(InputStream inStream, Class<? extends PulsarConfiguration> clazz) throws IOException, IllegalArgumentException {
        try {
            Preconditions.checkNotNull((Object)inStream);
            Properties properties = new Properties();
            properties.load(inStream);
            T t = ConfigurationUtils.create(properties, clazz);
            return t;
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    public static <T extends PulsarConfiguration> T create(Properties properties, Class<? extends PulsarConfiguration> clazz) {
        Preconditions.checkNotNull((Object)properties);
        PulsarConfiguration configuration = null;
        try {
            configuration = clazz.newInstance();
            configuration.setProperties(properties);
            ConfigurationUtils.update(properties, configuration);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz.getName(), e);
        }
        return (T)configuration;
    }

    public static <T> void update(Map<String, String> properties, T obj) throws IllegalArgumentException {
        Field[] fields = obj.getClass().getDeclaredFields();
        Field[] superFields = obj.getClass().getSuperclass().getDeclaredFields();
        Stream.of(fields, superFields).flatMap(Stream::of).forEach(f -> {
            if (properties.containsKey(f.getName())) {
                try {
                    f.setAccessible(true);
                    String v = (String)properties.get(f.getName());
                    if (!StringUtils.isBlank((CharSequence)v)) {
                        f.set(obj, FieldParser.value((String)v, (Field)f));
                    } else {
                        FieldParser.setEmptyValue((String)v, (Field)f, (Object)obj);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("failed to initialize %s field while setting value %s", f.getName(), properties.get(f.getName())), e);
                }
            }
        });
    }

    private ConfigurationUtils() {
    }
}

