/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class CoreUtils {
    public static <T> T inLock(Lock lock, Supplier<T> supplier) {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T inReadLock(ReadWriteLock lock, Supplier<T> supplier) {
        return CoreUtils.inLock(lock.readLock(), supplier);
    }

    public static <T> T inWriteLock(ReadWriteLock lock, Supplier<T> supplier) {
        return CoreUtils.inLock(lock.writeLock(), supplier);
    }

    public static <K, V> Map<Boolean, Map<K, V>> partition(Map<K, V> map, Predicate<K> predicate) {
        return map.entrySet().stream().collect(Collectors.partitioningBy(e -> predicate.test(e.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static <K, V1, V2> Map<K, V2> mapValue(Map<K, V1> map, Function<V1, V2> func) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> func.apply(e.getValue())));
    }

    public static <K, V1, V2> Map<K, V2> mapKeyValue(Map<K, V1> map, Function<Map.Entry<K, V1>, V2> func) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> func.apply((Map.Entry)e)));
    }

    public static <R, T> List<R> listToList(List<T> list, Function<T, R> function) {
        return list.stream().map(function).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> listToMap(List<K> list, Function<K, V> function) {
        return list.stream().collect(Collectors.toMap(key -> key, function));
    }

    public static <K, V, R> List<R> mapToList(Map<K, V> map, BiFunction<K, V, R> function) {
        return map.entrySet().stream().map(e -> function.apply(e.getKey(), e.getValue())).collect(Collectors.toList());
    }

    public static <T> CompletableFuture<Void> waitForAll(Collection<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public static <T, R> CompletableFuture<R> waitForAll(Collection<CompletableFuture<T>> futures, Function<List<T>, R> function) {
        return CoreUtils.waitForAll(futures).thenApply(__ -> function.apply(futures.stream().map(CompletableFuture::join).collect(Collectors.toList())));
    }

    private CoreUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

