/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.ListOffsetRequestV0;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;

public class KafkaRequestUtils {
    public static void forEachCreatePartitionsRequest(CreatePartitionsRequest request, BiConsumer<String, CreatePartitionsRequestData.CreatePartitionsTopic> consumer) {
        request.data().topics().forEach(tp -> consumer.accept(tp.name(), (CreatePartitionsRequestData.CreatePartitionsTopic)tp));
    }

    public static void forEachListOffsetRequest(ListOffsetsRequest request, BiConsumer<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> consumer) {
        request.data().topics().forEach(listOffsetsTopic -> {
            String name = listOffsetsTopic.name();
            listOffsetsTopic.partitions().forEach(listOffsetsPartition -> {
                TopicPartition topicPartition = new TopicPartition(name, listOffsetsPartition.partitionIndex());
                consumer.accept(topicPartition, (ListOffsetsRequestData.ListOffsetsPartition)listOffsetsPartition);
            });
        });
    }

    public static String getMetadata(TxnOffsetCommitRequest.CommittedOffset committedOffset) {
        return Optional.ofNullable(committedOffset.metadata).orElse("");
    }

    public static long getOffset(TxnOffsetCommitRequest.CommittedOffset committedOffset) {
        return committedOffset.offset;
    }

    public static class LegacyUtils {
        public static void forEachListOffsetRequest(ListOffsetRequestV0 request, Function<TopicPartition, Function<Long, Consumer<Integer>>> function) {
            request.offsetData().forEach((topicPartition, partitionData) -> ((Consumer)((Function)function.apply((TopicPartition)topicPartition)).apply(partitionData.timestamp)).accept(partitionData.maxNumOffsets));
        }

        public static long getRetentionTime(OffsetCommitRequest request) {
            return request.data().retentionTimeMs();
        }
    }
}

