/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import io.streamnative.pulsar.handlers.kop.ApiVersion;
import io.streamnative.pulsar.handlers.kop.coordinator.group.GroupMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteRecordsResponseData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.message.SaslHandshakeResponseData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.pulsar.common.schema.KeyValue;

public class KafkaResponseUtils {
    public static ApiVersionsResponse newApiVersions(List<ApiVersion> versionList) {
        ApiVersionsResponseData data = new ApiVersionsResponseData();
        versionList.forEach(apiVersion -> data.apiKeys().add((ImplicitLinkedHashCollection.Element)new ApiVersionsResponseData.ApiVersion().setApiKey(apiVersion.apiKey).setMinVersion(apiVersion.minVersion).setMaxVersion(apiVersion.maxVersion)));
        return new ApiVersionsResponse(data);
    }

    public static ApiVersionsResponse newApiVersions(Errors errors) {
        ApiVersionsResponseData data = new ApiVersionsResponseData().setErrorCode(errors.code());
        return new ApiVersionsResponse(data);
    }

    public static CreatePartitionsResponse newCreatePartitions(Map<String, ApiError> topicToErrors) {
        CreatePartitionsResponseData data = new CreatePartitionsResponseData().setThrottleTimeMs(0);
        topicToErrors.forEach((topic, errors) -> data.results().add(new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName(topic).setErrorCode(errors.error().code()).setErrorMessage(errors.messageWithFallback())));
        return new CreatePartitionsResponse(data);
    }

    public static CreateTopicsResponse newCreateTopics(Map<String, ApiError> errorMap) {
        CreateTopicsResponseData data = new CreateTopicsResponseData();
        errorMap.forEach((topic, errors) -> data.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsResponseData.CreatableTopicResult().setName(topic).setErrorMessage(errors.messageWithFallback()).setErrorCode(errors.error().code())));
        return new CreateTopicsResponse(data);
    }

    public static DeleteGroupsResponse newDeleteGroups(Map<String, Errors> groupToErrors) {
        DeleteGroupsResponseData deleteGroupsResponseData = new DeleteGroupsResponseData();
        groupToErrors.forEach((group, errors) -> deleteGroupsResponseData.results().add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(group).setErrorCode(errors.code())));
        return new DeleteGroupsResponse(deleteGroupsResponseData);
    }

    public static DeleteTopicsResponse newDeleteTopics(Map<String, Errors> topicToErrors) {
        DeleteTopicsResponseData deleteTopicsResponseData = new DeleteTopicsResponseData();
        topicToErrors.forEach((topic, errors) -> deleteTopicsResponseData.responses().add((ImplicitLinkedHashCollection.Element)new DeleteTopicsResponseData.DeletableTopicResult().setName(topic).setErrorCode(errors.code()).setErrorMessage(errors.message())));
        return new DeleteTopicsResponse(deleteTopicsResponseData);
    }

    public static DeleteRecordsResponse newDeleteRecords(Map<TopicPartition, Errors> responseMap) {
        DeleteRecordsResponseData data = new DeleteRecordsResponseData();
        responseMap.keySet().stream().map(TopicPartition::topic).distinct().forEach(topic -> {
            DeleteRecordsResponseData.DeleteRecordsTopicResult deleteRecordsTopicResult = new DeleteRecordsResponseData.DeleteRecordsTopicResult();
            deleteRecordsTopicResult.setName(topic);
            data.topics().add((ImplicitLinkedHashCollection.Element)deleteRecordsTopicResult);
            DeleteRecordsResponseData.DeleteRecordsPartitionResultCollection partitionResults = deleteRecordsTopicResult.partitions();
            responseMap.entrySet().stream().filter(entry -> ((TopicPartition)entry.getKey()).topic().equals(topic)).forEach(partitions -> {
                DeleteRecordsResponseData.DeleteRecordsPartitionResult result = new DeleteRecordsResponseData.DeleteRecordsPartitionResult().setPartitionIndex(((TopicPartition)partitions.getKey()).partition()).setErrorCode(((Errors)partitions.getValue()).code());
                partitionResults.add((ImplicitLinkedHashCollection.Element)result);
            });
        });
        return new DeleteRecordsResponse(data);
    }

    public static DescribeGroupsResponse newDescribeGroups(Map<String, KeyValue<Errors, GroupMetadata.GroupSummary>> groupToSummary) {
        DescribeGroupsResponseData data = new DescribeGroupsResponseData();
        groupToSummary.forEach((group, pair) -> {
            Errors errors = (Errors)pair.getKey();
            GroupMetadata.GroupSummary summary = (GroupMetadata.GroupSummary)pair.getValue();
            DescribeGroupsResponseData.DescribedGroup describedGroup = new DescribeGroupsResponseData.DescribedGroup().setGroupId(group).setErrorCode(errors.code()).setGroupState(summary.state()).setProtocolType(summary.protocolType()).setProtocolData(summary.protocol());
            data.groups().add(describedGroup);
            summary.members().forEach(member -> describedGroup.members().add(new DescribeGroupsResponseData.DescribedGroupMember().setClientHost(member.clientHost()).setMemberId(member.memberId()).setClientId(member.clientId()).setMemberMetadata(member.metadata()).setMemberAssignment(member.assignment())));
        });
        return new DescribeGroupsResponse(data);
    }

    public static FindCoordinatorResponse newFindCoordinator(Node node) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        data.setNodeId(node.id());
        data.setHost(node.host());
        data.setPort(node.port());
        data.setErrorCode(Errors.NONE.code());
        return new FindCoordinatorResponse(data);
    }

    public static FindCoordinatorResponse newFindCoordinator(Errors errors) {
        FindCoordinatorResponseData data = new FindCoordinatorResponseData();
        data.setErrorCode(errors.code());
        data.setErrorMessage(errors.message());
        return new FindCoordinatorResponse(data);
    }

    public static HeartbeatResponse newHeartbeat(Errors errors) {
        HeartbeatResponseData data = new HeartbeatResponseData();
        data.setErrorCode(errors.code());
        return new HeartbeatResponse(data);
    }

    public static JoinGroupResponse newJoinGroup(Errors errors, int generationId, String groupProtocol, String groupProtocolType, String memberId, String leaderId, Map<String, byte[]> groupMembers) {
        JoinGroupResponseData data = new JoinGroupResponseData().setErrorCode(errors.code()).setLeader(leaderId).setGenerationId(generationId).setMemberId(memberId).setProtocolType(groupProtocolType).setProtocolName(groupProtocol).setMembers(groupMembers.entrySet().stream().map(entry -> new JoinGroupResponseData.JoinGroupResponseMember().setMemberId((String)entry.getKey()).setMetadata((byte[])entry.getValue())).collect(Collectors.toList()));
        return new JoinGroupResponse(data);
    }

    public static LeaveGroupResponse newLeaveGroup(Errors errors) {
        LeaveGroupResponseData data = new LeaveGroupResponseData();
        data.setErrorCode(errors.code());
        return new LeaveGroupResponse(data);
    }

    public static ListGroupsResponse newListGroups(Errors errors, List<GroupMetadata.GroupOverview> groups) {
        ListGroupsResponseData data = new ListGroupsResponseData();
        data.setErrorCode(errors.code());
        data.setGroups(groups.stream().map(overView -> new ListGroupsResponseData.ListedGroup().setGroupId(overView.groupId()).setProtocolType(overView.protocolType())).collect(Collectors.toList()));
        return new ListGroupsResponse(data);
    }

    public static ListOffsetsResponse newListOffset(Map<TopicPartition, Pair<Errors, Long>> partitionToOffset, boolean legacy) {
        if (legacy) {
            ListOffsetsResponseData data = new ListOffsetsResponseData();
            List topicsResponse = data.topics();
            List<String> topics = partitionToOffset.keySet().stream().map(TopicPartition::topic).distinct().collect(Collectors.toList());
            topics.forEach(topic -> {
                ListOffsetsResponseData.ListOffsetsTopicResponse listOffsetsTopicResponse = new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(topic);
                topicsResponse.add(listOffsetsTopicResponse);
                partitionToOffset.forEach((topicPartition, errorsLongPair) -> {
                    if (topicPartition.topic().equals(topic)) {
                        Errors errors = (Errors)errorsLongPair.getKey();
                        long offset = errorsLongPair.getValue() != null ? (Long)errorsLongPair.getValue() : 0L;
                        listOffsetsTopicResponse.partitions().add(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setOldStyleOffsets(Collections.singletonList(offset)).setPartitionIndex(topicPartition.partition()).setErrorCode(errors.code()));
                    }
                });
            });
            return new ListOffsetsResponse(data);
        }
        ListOffsetsResponseData data = new ListOffsetsResponseData();
        List topicsResponse = data.topics();
        List<String> topics = partitionToOffset.keySet().stream().map(TopicPartition::topic).distinct().collect(Collectors.toList());
        topics.forEach(topic -> {
            ListOffsetsResponseData.ListOffsetsTopicResponse listOffsetsTopicResponse = new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(topic);
            topicsResponse.add(listOffsetsTopicResponse);
            partitionToOffset.forEach((topicPartition, errorsLongPair) -> {
                if (topicPartition.topic().equals(topic)) {
                    Errors errors = (Errors)errorsLongPair.getKey();
                    long offset = errorsLongPair.getValue() != null ? (Long)errorsLongPair.getValue() : 0L;
                    listOffsetsTopicResponse.partitions().add(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setOffset(offset).setTimestamp(0L).setPartitionIndex(topicPartition.partition()).setErrorCode(errors.code()));
                }
            });
        });
        return new ListOffsetsResponse(data);
    }

    public static MetadataResponse newMetadata(List<Node> nodes, String clusterName, int controllerId, List<MetadataResponse.TopicMetadata> topicMetadata, short apiVersion) {
        MetadataResponseData data = new MetadataResponseData().setClusterId(clusterName).setControllerId(controllerId);
        nodes.forEach(node -> data.brokers().add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setHost(node.host()).setNodeId(node.id()).setPort(node.port()).setRack(node.rack())));
        topicMetadata.forEach(md -> {
            MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic().setErrorCode(md.error().code()).setName(md.topic()).setIsInternal(md.isInternal());
            md.partitionMetadata().forEach(pd -> metadataResponseTopic.partitions().add(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(pd.partition()).setErrorCode(pd.error.code()).setIsrNodes(pd.inSyncReplicaIds).setLeaderEpoch(pd.leaderEpoch.orElse(-1).intValue()).setLeaderId(pd.leaderId.orElse(-1).intValue()).setOfflineReplicas(pd.offlineReplicaIds).setReplicaNodes(pd.replicaIds)));
            data.topics().add((ImplicitLinkedHashCollection.Element)metadataResponseTopic);
        });
        return new MetadataResponse(data, apiVersion);
    }

    public static BrokerLookupResult newMetadataPartition(TopicPartition topicPartition, Node node) {
        return new BrokerLookupResult(topicPartition, Errors.NONE, node);
    }

    public static BrokerLookupResult newMetadataPartition(Errors errors, TopicPartition topicPartition) {
        return new BrokerLookupResult(topicPartition, errors, null);
    }

    public static OffsetCommitResponse newOffsetCommit(Map<TopicPartition, Errors> responseData) {
        return new OffsetCommitResponse(responseData);
    }

    public static OffsetFetchResponse.PartitionData newOffsetFetchPartition(long offset, String metadata) {
        return new OffsetFetchResponse.PartitionData(offset, Optional.empty(), metadata, Errors.NONE);
    }

    public static OffsetFetchResponse.PartitionData newOffsetFetchPartition() {
        return new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.NONE);
    }

    public static SaslAuthenticateResponse newSaslAuthenticate(byte[] saslAuthBytes) {
        SaslAuthenticateResponseData data = new SaslAuthenticateResponseData();
        data.setErrorCode(Errors.NONE.code());
        data.setErrorMessage(Errors.NONE.message());
        data.setAuthBytes(saslAuthBytes);
        return new SaslAuthenticateResponse(data);
    }

    public static SaslAuthenticateResponse newSaslAuthenticate(Errors errors, String message) {
        SaslAuthenticateResponseData data = new SaslAuthenticateResponseData();
        data.setErrorCode(errors.code());
        data.setErrorMessage(message);
        return new SaslAuthenticateResponse(data);
    }

    public static SaslHandshakeResponse newSaslHandshake(Errors errors, Set<String> allowedMechanisms) {
        SaslHandshakeResponseData data = new SaslHandshakeResponseData();
        data.setErrorCode(errors.code());
        data.setMechanisms(new ArrayList<String>(allowedMechanisms));
        return new SaslHandshakeResponse(data);
    }

    public static SaslHandshakeResponse newSaslHandshake(Errors errors) {
        SaslHandshakeResponseData data = new SaslHandshakeResponseData();
        data.setErrorCode(errors.code());
        data.setMechanisms(Collections.emptyList());
        return new SaslHandshakeResponse(data);
    }

    public static SyncGroupResponse newSyncGroup(Errors errors, String protocolType, String protocolName, byte[] assignment) {
        SyncGroupResponseData data = new SyncGroupResponseData();
        data.setErrorCode(errors.code());
        data.setProtocolType(protocolType);
        data.setProtocolName(protocolName);
        data.setAssignment(assignment);
        return new SyncGroupResponse(data);
    }

    public static class BrokerLookupResult {
        public final TopicPartition topicPartition;
        public final Errors error;
        public final Node node;

        public MetadataResponse.PartitionMetadata toPartitionMetadata() {
            return new MetadataResponse.PartitionMetadata(this.error, this.topicPartition, Optional.ofNullable(this.node).map(Node::id), Optional.empty(), this.node != null ? Collections.singletonList(this.node.id()) : Collections.emptyList(), this.node != null ? Collections.singletonList(this.node.id()) : Collections.emptyList(), Collections.emptyList());
        }

        public TopicPartition getTopicPartition() {
            return this.topicPartition;
        }

        public Errors getError() {
            return this.error;
        }

        public Node getNode() {
            return this.node;
        }

        public BrokerLookupResult(TopicPartition topicPartition, Errors error, Node node) {
            this.topicPartition = topicPartition;
            this.error = error;
            this.node = node;
        }
    }
}

