/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import io.streamnative.pulsar.handlers.kop.exceptions.KoPTopicException;
import java.util.function.Function;
import org.apache.kafka.common.TopicPartition;
import org.apache.pulsar.common.naming.TopicName;

public class KopTopic {
    private static final String persistentDomain = "persistent://";
    private final String originalName;
    private final String fullName;

    public static String removeDefaultNamespacePrefix(String fullTopicName, String namespacePrefix) {
        String topicPrefix = persistentDomain + namespacePrefix + "/";
        if (fullTopicName.startsWith(topicPrefix)) {
            return fullTopicName.substring(topicPrefix.length());
        }
        return fullTopicName;
    }

    public KopTopic(String topic, String namespacePrefix) {
        this.originalName = topic;
        this.fullName = this.expandToFullName(topic, namespacePrefix);
    }

    private String expandToFullName(String topic, String namespacePrefix) {
        if (topic.startsWith(persistentDomain)) {
            if (topic.substring(persistentDomain.length()).split("/").length != 3) {
                throw new KoPTopicIllegalArgumentException("Invalid topic name '" + topic + "', it should be  persistent://<tenant>/<namespace>/<topic>");
            }
            return topic;
        }
        String[] parts = topic.split("/");
        if (parts.length == 3) {
            return persistentDomain + topic;
        }
        if (parts.length == 1 && namespacePrefix != null) {
            return persistentDomain + namespacePrefix + "/" + topic;
        }
        throw new KoPTopicIllegalArgumentException("Invalid short topic name '" + topic + "', it should be in the format of <tenant>/<namespace>/<topic> or <topic>");
    }

    public String getPartitionName(int partition) {
        if (partition < 0) {
            throw new KoPTopicIllegalArgumentException("Invalid partition " + partition + ", it should be non-negative number");
        }
        return this.fullName + "-partition-" + partition;
    }

    public static boolean isFullTopicName(String topic) {
        return topic.startsWith(persistentDomain);
    }

    public static String toString(TopicPartition topicPartition, String namespacePrefix) {
        return new KopTopic(topicPartition.topic(), namespacePrefix).getPartitionName(topicPartition.partition());
    }

    public static String toString(String topic, int partition, String namespacePrefix) {
        return new KopTopic(topic, namespacePrefix).getPartitionName(partition);
    }

    private static boolean validateTopic(String fullTopicName, String namespace, Function<String, Boolean> topicValidation) {
        TopicName topicName = TopicName.get((String)fullTopicName);
        if (!topicName.getNamespacePortion().equals(namespace)) {
            return false;
        }
        String localName = topicName.getLocalName();
        return topicValidation.apply(topicName.isPartitioned() ? localName.substring(0, localName.lastIndexOf("-partition-")) : localName);
    }

    public static boolean isInternalTopic(String fullTopicName, String metadataNamespace) {
        return KopTopic.validateTopic(fullTopicName, metadataNamespace, topic -> topic.equals("__consumer_offsets") || topic.equals("__transaction_state"));
    }

    public static boolean isGroupMetadataTopicName(String fullTopicName, String metadataNamespace) {
        return KopTopic.validateTopic(fullTopicName, metadataNamespace, topic -> topic.equals("__consumer_offsets"));
    }

    public static boolean isTransactionMetadataTopicName(String fullTopicName, String metadataNamespace) {
        return KopTopic.validateTopic(fullTopicName, metadataNamespace, topic -> topic.equals("__transaction_state"));
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static class KoPTopicIllegalArgumentException
    extends KoPTopicException {
        public KoPTopicIllegalArgumentException(String message) {
            super(message);
        }
    }
}

