/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.streamnative.pulsar.handlers.kop.exceptions.MetadataCorruptedException;
import io.streamnative.pulsar.handlers.kop.utils.MessageMetadataUtils;
import io.streamnative.pulsar.handlers.kop.utils.OpFindNewestEntry;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetFinder
implements AsyncCallbacks.FindEntryCallback {
    private static final Logger log = LoggerFactory.getLogger(OffsetFinder.class);
    private final ManagedLedgerImpl managedLedger;
    private long timestamp = 0L;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private volatile int messageFindInProgress = 0;
    private static final AtomicIntegerFieldUpdater<OffsetFinder> messageFindInProgressUpdater = AtomicIntegerFieldUpdater.newUpdater(OffsetFinder.class, "messageFindInProgress");

    public OffsetFinder(ManagedLedgerImpl managedLedger) {
        this.managedLedger = managedLedger;
    }

    public void findMessages(long timestamp, AsyncCallbacks.FindEntryCallback callback) {
        this.timestamp = timestamp;
        if (messageFindInProgressUpdater.compareAndSet(this, 0, 1)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Starting message position find at timestamp {}", (Object)this.managedLedger.getName(), (Object)timestamp);
            }
            this.asyncFindNewestMatching(ManagedCursor.FindPositionConstraint.SearchAllAvailableEntries, (Predicate<Entry>)((Predicate)entry -> {
                if (entry == null) {
                    return false;
                }
                try {
                    boolean bl = MessageMetadataUtils.getPublishTime(entry.getDataBuffer()) <= timestamp;
                    return bl;
                }
                catch (MetadataCorruptedException e) {
                    log.error("[{}] Error deserialize message for message position find", (Object)this.managedLedger.getName(), (Object)e);
                }
                finally {
                    entry.release();
                }
                return false;
            }), this, callback);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Ignore message position find scheduled task, last find is still running", (Object)this.managedLedger.getName());
            }
            callback.findEntryFailed((ManagedLedgerException)new ManagedLedgerException.ConcurrentFindCursorPositionException("last find is still running"), Optional.empty(), null);
        }
    }

    public void findEntryComplete(Position position, Object ctx) {
        Preconditions.checkArgument((boolean)(ctx instanceof AsyncCallbacks.FindEntryCallback));
        AsyncCallbacks.FindEntryCallback callback = (AsyncCallbacks.FindEntryCallback)ctx;
        if (position != null) {
            log.info("[{}] Found position {} closest to provided timestamp {}", new Object[]{this.managedLedger.getName(), position, this.timestamp});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] No position found closest to provided timestamp {}", (Object)this.managedLedger.getName(), (Object)this.timestamp);
        }
        this.messageFindInProgress = 0;
        callback.findEntryComplete(position, null);
    }

    public void findEntryFailed(ManagedLedgerException exception, Optional<Position> position, Object ctx) {
        Preconditions.checkArgument((boolean)(ctx instanceof AsyncCallbacks.FindEntryCallback));
        AsyncCallbacks.FindEntryCallback callback = (AsyncCallbacks.FindEntryCallback)ctx;
        if (log.isDebugEnabled()) {
            log.debug("[{}] Message position find operation failed for provided timestamp {}", new Object[]{this.managedLedger.getName(), this.timestamp, exception});
        }
        this.messageFindInProgress = 0;
        callback.findEntryFailed(exception, position, null);
    }

    public void asyncFindNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        Preconditions.checkState((constraint == ManagedCursor.FindPositionConstraint.SearchAllAvailableEntries ? 1 : 0) != 0);
        PositionImpl startPosition = this.managedLedger.getFirstPosition();
        long max = this.managedLedger.getNumberOfEntries() - 1L;
        if (startPosition == null) {
            callback.findEntryFailed(new ManagedLedgerException("Couldn't find start position"), Optional.empty(), ctx);
            return;
        }
        startPosition = this.managedLedger.getNextValidPosition(startPosition);
        OpFindNewestEntry op = new OpFindNewestEntry(this.managedLedger, startPosition, condition, max, callback, ctx);
        op.find();
    }

    public static PositionImpl getFirstValidPosition(ManagedLedgerImpl managedLedger) {
        Map.Entry entry;
        PositionImpl firstPosition = managedLedger.getFirstPosition();
        if (firstPosition == null) {
            return null;
        }
        PositionImpl validPosition = managedLedger.getNextValidPosition(firstPosition);
        NavigableMap ledgers = managedLedger.getLedgersInfo();
        if (!ledgers.containsKey(validPosition.getLedgerId()) && (entry = ledgers.firstEntry()) != null && ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)entry.getValue()).hasEntries() && ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)entry.getValue()).getEntries() > 0L) {
            log.warn("ManagedLedger {} is not empty and doesn't contain {}, return the first position {}:0", new Object[]{managedLedger.getName(), validPosition, entry.getKey()});
            return PositionImpl.get((long)((Long)entry.getKey()), (long)0L);
        }
        return validPosition;
    }
}

