/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.common.api.proto.MessageMetadata;

public class PulsarMessageBuilder {
    private static final ByteBuffer EMPTY_CONTENT = ByteBuffer.allocate(0);
    private static final Schema<byte[]> SCHEMA = Schema.BYTES;
    private final transient MessageMetadata metadata = (MessageMetadata)LOCAL_MESSAGE_METADATA.get();
    private transient ByteBuffer content;
    private static final FastThreadLocal<MessageMetadata> LOCAL_MESSAGE_METADATA = new FastThreadLocal<MessageMetadata>(){

        protected MessageMetadata initialValue() {
            return new MessageMetadata();
        }
    };

    private PulsarMessageBuilder() {
        this.metadata.clear();
        this.content = EMPTY_CONTENT;
    }

    public static PulsarMessageBuilder newBuilder() {
        return new PulsarMessageBuilder();
    }

    public PulsarMessageBuilder keyBytes(byte[] key) {
        this.metadata.setPartitionKey(Base64.getEncoder().encodeToString(key));
        this.metadata.setPartitionKeyB64Encoded(true);
        return this;
    }

    public PulsarMessageBuilder orderingKey(byte[] orderingKey) {
        this.metadata.setOrderingKey(orderingKey);
        return this;
    }

    public PulsarMessageBuilder value(byte[] value) {
        if (value == null) {
            this.metadata.setNullValue(true);
            return this;
        }
        this.content = ByteBuffer.wrap(SCHEMA.encode((Object)value));
        return this;
    }

    public PulsarMessageBuilder property(String name, String value) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Need Non-Null name");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)("Need Non-Null value for name: " + name));
        this.metadata.addProperty().setKey(name).setValue(value);
        return this;
    }

    public PulsarMessageBuilder properties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            Preconditions.checkArgument((entry.getKey() != null ? 1 : 0) != 0, (Object)"Need Non-Null key");
            Preconditions.checkArgument((entry.getValue() != null ? 1 : 0) != 0, (Object)("Need Non-Null value for key: " + entry.getKey()));
            this.metadata.addProperty().setKey(entry.getKey()).setValue(entry.getValue());
        }
        return this;
    }

    public PulsarMessageBuilder eventTime(long timestamp) {
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (String)"Invalid timestamp : '%s'", (long)timestamp);
        this.metadata.setEventTime(timestamp);
        return this;
    }

    public MessageMetadata getMetadataBuilder() {
        return this.metadata;
    }

    public PulsarMessageBuilder sequenceId(long sequenceId) {
        Preconditions.checkArgument((sequenceId >= 0L ? 1 : 0) != 0);
        this.metadata.setSequenceId(sequenceId);
        return this;
    }

    public Message<byte[]> getMessage() {
        return MessageImpl.create((MessageMetadata)this.metadata, (ByteBuffer)this.content, SCHEMA, null);
    }
}

