/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtils {
    public static <T> T getSuperField(Object privateObject, String fieldName) {
        try {
            Field privateField = privateObject.getClass().getSuperclass().getDeclaredField(fieldName);
            privateField.setAccessible(true);
            return (T)privateField.get(privateObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Unable to access field '" + fieldName + "'", e);
        }
    }

    public static <T> void setSuperField(Object privateObject, String fieldName, T fieldValue) throws IllegalAccessException, NoSuchFieldException {
        Field privateField = privateObject.getClass().getSuperclass().getDeclaredField(fieldName);
        privateField.setAccessible(true);
        privateField.set(privateObject, fieldValue);
    }

    public static void callSuperNoArgVoidMethod(Object privateObject, String methodName) throws Exception {
        try {
            Method privateStringMethod = privateObject.getClass().getSuperclass().getDeclaredMethod(methodName, null);
            privateStringMethod.setAccessible(true);
            privateStringMethod.invoke(privateObject, (Object[])null);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Unable to call method '" + methodName + "'", e);
        }
        catch (InvocationTargetException e) {
            if (null == e.getCause()) {
                throw e;
            }
            throw (Exception)e.getCause();
        }
    }

    public static Method setMethodAccessible(Object privateObject, String methodName, Class<?> ... parameterTypes) throws Exception {
        Method privateStringMethod = privateObject.getClass().getDeclaredMethod(methodName, parameterTypes);
        privateStringMethod.setAccessible(true);
        return privateStringMethod;
    }

    private ReflectionUtils() {
    }
}

