/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import io.streamnative.pulsar.handlers.kop.SaslAuth;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.security.sasl.SaslException;

public class SaslUtils {
    public static SaslAuth parseSaslAuthBytes(byte[] buf) throws IOException {
        String[] tokens = new String(buf, StandardCharsets.UTF_8).split("\u0000");
        if (tokens.length != 3) {
            throw new SaslException("Invalid SASL/PLAIN response: expected 3 tokens, got " + tokens.length);
        }
        String username = tokens[1];
        String password = tokens[2];
        if (username.isEmpty()) {
            throw new IOException("Authentication failed: username not specified");
        }
        if (password.isEmpty()) {
            throw new IOException("Authentication failed: password not specified");
        }
        if (password.split(":").length != 2) {
            throw new IOException("Authentication failed: password not specified");
        }
        String authMethod = password.split(":")[0];
        if (authMethod.isEmpty()) {
            throw new IOException("Authentication failed: authMethod not specified");
        }
        password = password.split(":")[1];
        return new SaslAuth(username, authMethod, password);
    }
}

