/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShutdownableThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ShutdownableThread.class);
    private final boolean isInterruptible;
    private final String logIdent;
    private final CountDownLatch shutdownInitiated = new CountDownLatch(1);
    private final CountDownLatch shutdownComplete = new CountDownLatch(1);

    public ShutdownableThread(String name) {
        this(name, true);
    }

    public ShutdownableThread(String name, boolean isInterruptible) {
        super(name);
        this.isInterruptible = isInterruptible;
        this.setDaemon(false);
        this.logIdent = "[" + name + "]";
    }

    public boolean isRunning() {
        return this.shutdownInitiated.getCount() != 0L;
    }

    public void shutdown() throws InterruptedException {
        this.initiateShutdown();
        this.awaitShutdown();
    }

    public boolean isShutdownComplete() {
        return this.shutdownComplete.getCount() == 0L;
    }

    public synchronized boolean initiateShutdown() {
        if (this.isRunning() && log.isDebugEnabled()) {
            log.debug("{} Shutting down", (Object)this.logIdent);
        }
        this.shutdownInitiated.countDown();
        if (this.isInterruptible) {
            this.interrupt();
            return true;
        }
        return false;
    }

    public void awaitShutdown() throws InterruptedException {
        this.shutdownComplete.await();
        if (log.isDebugEnabled()) {
            log.debug("{} Shutdown completed", (Object)this.logIdent);
        }
    }

    public void pause(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.shutdownInitiated.await(timeout, unit) && log.isTraceEnabled()) {
            log.trace("{} shutdownInitiated latch count reached zero. Shutdown called.", (Object)this.logIdent);
        }
    }

    protected abstract void doWork();

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("{} Starting", (Object)this.logIdent);
        }
        try {
            while (this.isRunning()) {
                this.doWork();
            }
        }
        catch (FatalExitError e) {
            this.shutdownInitiated.countDown();
            this.shutdownComplete.countDown();
            if (log.isDebugEnabled()) {
                log.debug("{} Stopped", (Object)this.logIdent);
            }
            Exit.exit((int)e.statusCode());
        }
        catch (Throwable cause) {
            if (this.isRunning()) {
                log.error("{} Error due to", (Object)this.logIdent, (Object)cause);
            }
        }
        finally {
            this.shutdownComplete.countDown();
        }
    }
}

