/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import org.apache.kafka.common.TopicPartition;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;

public class TopicNameUtils {
    public static TopicName pulsarTopicName(TopicPartition topicPartition, NamespaceName namespace) {
        return TopicNameUtils.pulsarTopicName(topicPartition.topic(), topicPartition.partition(), namespace);
    }

    public static TopicName pulsarTopicName(TopicPartition topicPartition) {
        return TopicNameUtils.pulsarTopicName(topicPartition.topic(), topicPartition.partition());
    }

    private static TopicName pulsarTopicName(String topic, int partitionIndex) {
        return TopicName.get((String)(topic + "-partition-" + partitionIndex));
    }

    public static TopicName pulsarTopicName(String topic, NamespaceName namespace) {
        return TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespace, (String)topic);
    }

    public static TopicName pulsarTopicName(String topic) {
        return TopicName.get((String)topic);
    }

    public static TopicName pulsarTopicName(String topic, int partitionIndex, NamespaceName namespace) {
        if (topic.startsWith(TopicDomain.persistent.value())) {
            topic = topic.replace(TopicDomain.persistent.value() + "://", "");
        }
        if (topic.contains(namespace.getNamespaceObject().toString())) {
            topic = topic.replace(namespace.getNamespaceObject().toString() + "/", "");
        }
        return TopicName.get((String)TopicDomain.persistent.value(), (NamespaceName)namespace, (String)(topic + "-partition-" + partitionIndex));
    }

    public static String getPartitionedTopicNameWithoutPartitions(TopicName topicName) {
        String localName = topicName.getPartitionedTopicName();
        if (localName.contains("-partition-")) {
            return localName.substring(0, localName.lastIndexOf("-partition-"));
        }
        return localName;
    }

    @NonNull
    public static String getTopicNameWithUrlEncoded(String topicName) {
        String encodedTopicName = "";
        try {
            encodedTopicName = URLEncoder.encode(topicName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedTopicName;
    }

    @NonNull
    public static String getTopicNameWithUrlDecoded(String encodedTopicName) {
        String topicName = "";
        try {
            topicName = URLDecoder.decode(encodedTopicName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return topicName;
    }
}

