/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils.delayed;

import io.streamnative.pulsar.handlers.kop.utils.timer.TimerTask;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelayedOperation
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(DelayedOperation.class);
    protected final Optional<Lock> lockOpt;
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final AtomicBoolean tryCompletePending = new AtomicBoolean(false);
    final Lock lock;

    protected DelayedOperation(long delayMs, Optional<Lock> lockOpt) {
        super(delayMs);
        this.lockOpt = lockOpt;
        this.lock = lockOpt.orElseGet(() -> new ReentrantLock());
    }

    public boolean forceComplete() {
        if (this.completed.compareAndSet(false, true)) {
            this.cancel();
            this.onComplete();
            return true;
        }
        return false;
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    public abstract void onExpiration();

    public abstract void onComplete();

    public abstract boolean tryComplete();

    boolean maybeTryComplete() {
        boolean retry = false;
        boolean done = false;
        do {
            if (this.lock.tryLock()) {
                try {
                    this.tryCompletePending.set(false);
                    done = this.tryComplete();
                }
                finally {
                    this.lock.unlock();
                }
                retry = this.tryCompletePending.get();
                continue;
            }
            boolean bl = retry = !this.tryCompletePending.getAndSet(true);
        } while (!this.isCompleted() && retry);
        return done;
    }

    @Override
    public void run() {
        if (this.forceComplete()) {
            this.onExpiration();
        }
    }
}

