/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils.delayed;

import org.apache.kafka.common.TopicPartition;

public interface DelayedOperationKey {
    public String keyLabel();

    public static class TopicPartitionOperationKey
    implements DelayedOperationKey {
        private final TopicPartition topicPartition;

        @Override
        public String keyLabel() {
            return String.format("%s-%d", this.topicPartition.topic(), this.topicPartition.partition());
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicPartitionOperationKey)) {
                return false;
            }
            TopicPartitionOperationKey other = (TopicPartitionOperationKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TopicPartition this$topicPartition = this.topicPartition();
            TopicPartition other$topicPartition = other.topicPartition();
            return !(this$topicPartition == null ? other$topicPartition != null : !this$topicPartition.equals(other$topicPartition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopicPartitionOperationKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TopicPartition $topicPartition = this.topicPartition();
            result = result * 59 + ($topicPartition == null ? 43 : $topicPartition.hashCode());
            return result;
        }

        public String toString() {
            return "DelayedOperationKey.TopicPartitionOperationKey(topicPartition=" + this.topicPartition() + ")";
        }

        public TopicPartitionOperationKey(TopicPartition topicPartition) {
            this.topicPartition = topicPartition;
        }
    }

    public static class TopicKey
    implements DelayedOperationKey {
        private final String topic;

        @Override
        public String keyLabel() {
            return this.topic;
        }

        public String topic() {
            return this.topic;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicKey)) {
                return false;
            }
            TopicKey other = (TopicKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$topic = this.topic();
            String other$topic = other.topic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopicKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $topic = this.topic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }

        public String toString() {
            return "DelayedOperationKey.TopicKey(topic=" + this.topic() + ")";
        }

        public TopicKey(String topic) {
            this.topic = topic;
        }
    }

    public static class GroupKey
    implements DelayedOperationKey {
        private final String groupId;

        @Override
        public String keyLabel() {
            return this.groupId;
        }

        public String groupId() {
            return this.groupId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupKey)) {
                return false;
            }
            GroupKey other = (GroupKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.groupId();
            String other$groupId = other.groupId();
            return !(this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.groupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            return result;
        }

        public String toString() {
            return "DelayedOperationKey.GroupKey(groupId=" + this.groupId() + ")";
        }

        public GroupKey(String groupId) {
            this.groupId = groupId;
        }
    }

    public static class MemberKey
    implements DelayedOperationKey {
        private final String groupId;
        private final String consumerId;

        @Override
        public String keyLabel() {
            return String.format("%s-%s", this.groupId, this.consumerId);
        }

        public String groupId() {
            return this.groupId;
        }

        public String consumerId() {
            return this.consumerId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MemberKey)) {
                return false;
            }
            MemberKey other = (MemberKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.groupId();
            String other$groupId = other.groupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$consumerId = this.consumerId();
            String other$consumerId = other.consumerId();
            return !(this$consumerId == null ? other$consumerId != null : !this$consumerId.equals(other$consumerId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MemberKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.groupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $consumerId = this.consumerId();
            result = result * 59 + ($consumerId == null ? 43 : $consumerId.hashCode());
            return result;
        }

        public String toString() {
            return "DelayedOperationKey.MemberKey(groupId=" + this.groupId() + ", consumerId=" + this.consumerId() + ")";
        }

        public MemberKey(String groupId, String consumerId) {
            this.groupId = groupId;
            this.consumerId = consumerId;
        }
    }
}

