/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils.ssl;

import com.google.common.collect.ImmutableMap;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.types.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtils {
    private static final Logger log = LoggerFactory.getLogger(SSLUtils.class);
    public static final Map<String, String> CONFIG_NAME_MAP = ImmutableMap.builder().put((Object)"ssl.protocol", (Object)"kopSslProtocol").put((Object)"ssl.provider", (Object)"kopSslProvider").put((Object)"ssl.cipher.suites", (Object)"kopSslCipherSuites").put((Object)"ssl.enabled.protocols", (Object)"kopSslEnabledProtocols").put((Object)"ssl.keystore.type", (Object)"kopSslKeystoreType").put((Object)"ssl.keystore.location", (Object)"kopSslKeystoreLocation").put((Object)"ssl.keystore.password", (Object)"kopSslKeystorePassword").put((Object)"ssl.key.password", (Object)"kopSslKeyPassword").put((Object)"ssl.truststore.type", (Object)"kopSslTruststoreType").put((Object)"ssl.truststore.location", (Object)"kopSslTruststoreLocation").put((Object)"ssl.truststore.password", (Object)"kopSslTruststorePassword").put((Object)"ssl.keymanager.algorithm", (Object)"kopSslKeymanagerAlgorithm").put((Object)"ssl.trustmanager.algorithm", (Object)"kopSslTrustmanagerAlgorithm").put((Object)"ssl.secure.random.implementation", (Object)"kopSslSecureRandomImplementation").put((Object)"ssl.client.auth", (Object)"kopSslClientAuth").build();

    public static SslContextFactory.Server createSslContextFactory(KafkaServiceConfiguration kafkaServiceConfiguration) {
        ImmutableMap.Builder sslConfigValues = ImmutableMap.builder();
        CONFIG_NAME_MAP.forEach((key, value) -> {
            Object obj = null;
            switch (key) {
                case "ssl.protocol": {
                    obj = kafkaServiceConfiguration.getKopSslProtocol();
                    break;
                }
                case "ssl.provider": {
                    obj = kafkaServiceConfiguration.getKopSslProvider();
                    break;
                }
                case "ssl.cipher.suites": {
                    obj = kafkaServiceConfiguration.getKopSslCipherSuites();
                    break;
                }
                case "ssl.enabled.protocols": {
                    obj = kafkaServiceConfiguration.getKopSslEnabledProtocols();
                    break;
                }
                case "ssl.keystore.type": {
                    obj = kafkaServiceConfiguration.getKopSslKeystoreType();
                    break;
                }
                case "ssl.keystore.location": {
                    obj = kafkaServiceConfiguration.getKopSslKeystoreLocation();
                    break;
                }
                case "ssl.keystore.password": {
                    obj = kafkaServiceConfiguration.getKopSslKeystorePassword();
                    break;
                }
                case "ssl.key.password": {
                    obj = kafkaServiceConfiguration.getKopSslKeyPassword();
                    break;
                }
                case "ssl.truststore.type": {
                    obj = kafkaServiceConfiguration.getKopSslTruststoreType();
                    break;
                }
                case "ssl.truststore.location": {
                    obj = kafkaServiceConfiguration.getKopSslTruststoreLocation();
                    break;
                }
                case "ssl.truststore.password": {
                    obj = kafkaServiceConfiguration.getKopSslTruststorePassword();
                    break;
                }
                case "ssl.keymanager.algorithm": {
                    obj = kafkaServiceConfiguration.getKopSslKeymanagerAlgorithm();
                    break;
                }
                case "ssl.trustmanager.algorithm": {
                    obj = kafkaServiceConfiguration.getKopSslTrustmanagerAlgorithm();
                    break;
                }
                case "ssl.secure.random.implementation": {
                    obj = kafkaServiceConfiguration.getKopSslSecureRandomImplementation();
                    break;
                }
                case "ssl.client.auth": {
                    obj = kafkaServiceConfiguration.getKopSslClientAuth();
                    break;
                }
                default: {
                    log.error("key {} not contained in KafkaServiceConfiguration", key);
                }
            }
            if (obj != null) {
                sslConfigValues.put(key, obj);
            }
        });
        return SSLUtils.createSslContextFactory((Map<String, Object>)sslConfigValues.build());
    }

    public static SslContextFactory.Server createSslContextFactory(Map<String, Object> sslConfigValues) {
        SslContextFactory.Server ssl = new SslContextFactory.Server();
        SSLUtils.configureSslContextFactoryKeyStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAuthentication(ssl, sslConfigValues);
        ssl.setEndpointIdentificationAlgorithm(null);
        return ssl;
    }

    protected static void configureSslContextFactoryKeyStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslKeyPassword;
        Password sslKeystorePassword;
        ssl.setKeyStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keystore.type", "JKS"));
        String sslKeystoreLocation = (String)sslConfigValues.get("ssl.keystore.location");
        if (sslKeystoreLocation != null) {
            ssl.setKeyStorePath(sslKeystoreLocation);
        }
        if ((sslKeystorePassword = new Password((String)sslConfigValues.get("ssl.keystore.password"))) != null) {
            ssl.setKeyStorePassword(sslKeystorePassword.value());
        }
        if ((sslKeyPassword = new Password((String)sslConfigValues.get("ssl.key.password"))) != null) {
            ssl.setKeyManagerPassword(sslKeyPassword.value());
        }
    }

    protected static Object getOrDefault(Map<String, Object> configMap, String key, Object defaultValue) {
        if (configMap.containsKey(key)) {
            return configMap.get(key);
        }
        return defaultValue;
    }

    protected static void configureSslContextFactoryTrustStore(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Password sslTruststorePassword;
        ssl.setTrustStoreType((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.truststore.type", "JKS"));
        String sslTruststoreLocation = (String)sslConfigValues.get("ssl.truststore.location");
        if (sslTruststoreLocation != null) {
            ssl.setTrustStorePath(sslTruststoreLocation);
        }
        if ((sslTruststorePassword = new Password((String)sslConfigValues.get("ssl.truststore.password"))) != null) {
            ssl.setTrustStorePassword(sslTruststorePassword.value());
        }
    }

    protected static void configureSslContextFactoryAlgorithms(SslContextFactory ssl, Map<String, Object> sslConfigValues) {
        Set sslEnabledProtocols = (Set)SSLUtils.getOrDefault(sslConfigValues, "ssl.enabled.protocols", Arrays.asList(SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS.split("\\s*,\\s*")));
        ssl.setIncludeProtocols(sslEnabledProtocols.toArray(new String[sslEnabledProtocols.size()]));
        String sslProvider = (String)sslConfigValues.get("ssl.provider");
        if (sslProvider != null) {
            ssl.setProvider(sslProvider);
        }
        ssl.setProtocol((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.protocol", SslConfigs.DEFAULT_SSL_PROTOCOL));
        Set sslCipherSuites = (Set)sslConfigValues.get("ssl.cipher.suites");
        if (sslCipherSuites != null) {
            ssl.setIncludeCipherSuites(sslCipherSuites.toArray(new String[sslCipherSuites.size()]));
        }
        ssl.setKeyManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.keymanager.algorithm", SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM));
        String sslSecureRandomImpl = (String)sslConfigValues.get("ssl.secure.random.implementation");
        if (sslSecureRandomImpl != null) {
            ssl.setSecureRandomAlgorithm(sslSecureRandomImpl);
        }
        ssl.setTrustManagerFactoryAlgorithm((String)SSLUtils.getOrDefault(sslConfigValues, "ssl.trustmanager.algorithm", SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM));
    }

    protected static void configureSslContextFactoryAuthentication(SslContextFactory.Server ssl, Map<String, Object> sslConfigValues) {
        String sslClientAuth;
        switch (sslClientAuth = (String)SSLUtils.getOrDefault(sslConfigValues, "ssl.client.auth", "none")) {
            case "requested": {
                ssl.setWantClientAuth(true);
                break;
            }
            case "required": {
                ssl.setNeedClientAuth(true);
                break;
            }
            default: {
                ssl.setNeedClientAuth(false);
                ssl.setWantClientAuth(false);
            }
        }
    }

    public static SSLEngine createSslEngine(SslContextFactory.Server sslContextFactory) throws Exception {
        sslContextFactory.start();
        SSLEngine engine = sslContextFactory.newSSLEngine();
        engine.setUseClientMode(false);
        return engine;
    }

    public static SSLEngine createClientSslEngine(SslContextFactory.Client sslContextFactory) throws Exception {
        sslContextFactory.start();
        SSLEngine engine = sslContextFactory.newSSLEngine();
        engine.setUseClientMode(true);
        return engine;
    }

    public static SslContextFactory.Client createClientSslContextFactory(KafkaServiceConfiguration kafkaServiceConfiguration) {
        ImmutableMap.Builder sslConfigValues = ImmutableMap.builder();
        CONFIG_NAME_MAP.forEach((key, value) -> {
            Object obj = null;
            switch (key) {
                case "ssl.protocol": {
                    obj = kafkaServiceConfiguration.getKopSslProtocol();
                    break;
                }
                case "ssl.provider": {
                    obj = kafkaServiceConfiguration.getKopSslProvider();
                    break;
                }
                case "ssl.cipher.suites": {
                    obj = kafkaServiceConfiguration.getKopSslCipherSuites();
                    break;
                }
                case "ssl.enabled.protocols": {
                    obj = kafkaServiceConfiguration.getKopSslEnabledProtocols();
                    break;
                }
                case "ssl.keystore.type": {
                    obj = kafkaServiceConfiguration.getKopSslKeystoreType();
                    break;
                }
                case "ssl.keystore.location": {
                    obj = kafkaServiceConfiguration.getKopSslKeystoreLocation();
                    break;
                }
                case "ssl.keystore.password": {
                    obj = kafkaServiceConfiguration.getKopSslKeystorePassword();
                    break;
                }
                case "ssl.key.password": {
                    obj = kafkaServiceConfiguration.getKopSslKeyPassword();
                    break;
                }
                case "ssl.truststore.type": {
                    obj = kafkaServiceConfiguration.getKopSslTruststoreType();
                    break;
                }
                case "ssl.truststore.location": {
                    obj = kafkaServiceConfiguration.getKopSslTruststoreLocation();
                    break;
                }
                case "ssl.truststore.password": {
                    obj = kafkaServiceConfiguration.getKopSslTruststorePassword();
                    break;
                }
                case "ssl.keymanager.algorithm": {
                    obj = kafkaServiceConfiguration.getKopSslKeymanagerAlgorithm();
                    break;
                }
                case "ssl.trustmanager.algorithm": {
                    obj = kafkaServiceConfiguration.getKopSslTrustmanagerAlgorithm();
                    break;
                }
                case "ssl.secure.random.implementation": {
                    obj = kafkaServiceConfiguration.getKopSslSecureRandomImplementation();
                    break;
                }
                case "ssl.client.auth": {
                    obj = kafkaServiceConfiguration.getKopSslClientAuth();
                    break;
                }
                default: {
                    log.error("key {} not contained in KafkaServiceConfiguration", key);
                }
            }
            if (obj != null) {
                sslConfigValues.put(key, obj);
            }
        });
        return SSLUtils.createClientSslContextFactory((Map<String, Object>)sslConfigValues.build());
    }

    public static SslContextFactory.Client createClientSslContextFactory(Map<String, Object> sslConfigValues) {
        SslContextFactory.Client ssl = new SslContextFactory.Client();
        SSLUtils.configureSslContextFactoryTrustStore((SslContextFactory)ssl, sslConfigValues);
        SSLUtils.configureSslContextFactoryAlgorithms((SslContextFactory)ssl, sslConfigValues);
        ssl.setEndpointIdentificationAlgorithm(null);
        return ssl;
    }
}

