/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils.timer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.streamnative.pulsar.handlers.kop.utils.timer.Timer;
import io.streamnative.pulsar.handlers.kop.utils.timer.TimerTask;
import io.streamnative.pulsar.handlers.kop.utils.timer.TimerTaskList;
import io.streamnative.pulsar.handlers.kop.utils.timer.TimingWheel;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SystemTimer
implements Timer {
    private static final Logger log = LoggerFactory.getLogger(SystemTimer.class);
    private final ExecutorService taskExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("system-timer-%d").build());
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private final AtomicInteger taskCounter = new AtomicInteger(0);
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;
    private final Consumer<TimerTaskList.TimerTaskEntry> reinsert;

    public static Builder builder() {
        return new Builder();
    }

    private SystemTimer(String executorName, long tickMs, int wheelSize, long startMs) {
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.reinsert = timerTaskEntry -> this.addTimerTaskEntry((TimerTaskList.TimerTaskEntry)timerTaskEntry);
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskList.TimerTaskEntry(timerTask, timerTask.delayMs + Time.SYSTEM.hiResClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addTimerTaskEntry(TimerTaskList.TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(timerTaskEntry.timerTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (null != bucket) {
            this.writeLock.lock();
            try {
                while (null != bucket) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush(this.reinsert);
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    public static class Builder {
        private String executorName;
        private long tickMs = 1L;
        private int wheelSize = 20;
        private long startMs = Time.SYSTEM.hiResClockMs();

        private Builder() {
        }

        public Builder executorName(String executorName) {
            this.executorName = executorName;
            return this;
        }

        public Builder tickMs(long tickMs) {
            this.tickMs = tickMs;
            return this;
        }

        public Builder wheelSize(int wheelSize) {
            this.wheelSize = wheelSize;
            return this;
        }

        public Builder startMs(long startMs) {
            this.startMs = startMs;
            return this;
        }

        public SystemTimer build() {
            Objects.requireNonNull(this.executorName, "No executor name is provided");
            return new SystemTimer(this.executorName, this.tickMs, this.wheelSize, this.startMs);
        }
    }
}

