/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils.timer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.streamnative.pulsar.handlers.kop.utils.timer.TimerTask;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS", "HE_EQUALS_USE_HASHCODE"})
@ThreadSafe
public class TimerTaskList
implements Delayed {
    private static final Logger log = LoggerFactory.getLogger(TimerTaskList.class);
    private final AtomicInteger taskCounter;
    private final AtomicLong expiration;
    private final TimerTaskEntry root;

    public TimerTaskList(AtomicInteger taskCounter) {
        this.taskCounter = taskCounter;
        this.root.next = this.root = new TimerTaskEntry(null, -1L);
        this.root.prev = this.root;
        this.expiration = new AtomicLong(-1L);
    }

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    public synchronized void forEach(Consumer<TimerTask> f) {
        TimerTaskEntry entry = this.root.next;
        while (entry != this.root) {
            TimerTaskEntry nextEntry = entry.next;
            if (!entry.cancelled()) {
                f.accept(entry.timerTask);
            }
            entry = nextEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            TimerTaskList timerTaskList = this;
            synchronized (timerTaskList) {
                TimerTaskEntry timerTaskEntry2 = timerTaskEntry;
                synchronized (timerTaskEntry2) {
                    if (timerTaskEntry.list == null) {
                        TimerTaskEntry tail = this.root.prev;
                        timerTaskEntry.next = this.root;
                        timerTaskEntry.prev = tail;
                        timerTaskEntry.list = this;
                        tail.next = timerTaskEntry;
                        this.root.prev = timerTaskEntry;
                        this.taskCounter.incrementAndGet();
                        done = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry timerTaskEntry2 = timerTaskEntry;
            synchronized (timerTaskEntry2) {
                if (timerTaskEntry.list == this) {
                    timerTaskEntry.next.prev = timerTaskEntry.prev;
                    timerTaskEntry.prev.next = timerTaskEntry.next;
                    timerTaskEntry.next = null;
                    timerTaskEntry.prev = null;
                    timerTaskEntry.list = null;
                    this.taskCounter.decrementAndGet();
                }
            }
        }
    }

    public synchronized void flush(Consumer<TimerTaskEntry> f) {
        TimerTaskEntry head = this.root.next;
        while (head != this.root) {
            this.remove(head);
            f.accept(head);
            head = this.root.next;
        }
        this.expiration.set(-1L);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Math.max(this.getExpiration() - Time.SYSTEM.hiResClockMs(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        TimerTaskList other = (TimerTaskList)o;
        if (this.getExpiration() < other.getExpiration()) {
            return -1;
        }
        if (this.getExpiration() > other.getExpiration()) {
            return 1;
        }
        return 0;
    }

    protected static class TimerTaskEntry
    implements Comparable<TimerTaskEntry> {
        private final TimerTask timerTask;
        private final long expirationMs;
        private volatile TimerTaskList list = null;
        private TimerTaskEntry next = null;
        private TimerTaskEntry prev = null;

        public TimerTaskEntry(TimerTask timerTask, long expirationMs) {
            this.timerTask = timerTask;
            this.expirationMs = expirationMs;
            if (null != timerTask) {
                timerTask.setTimerTaskEntry(this);
            }
        }

        public boolean cancelled() {
            return this.timerTask.getTimerTaskEntry() != this;
        }

        public void remove() {
            TimerTaskList currentList = this.list;
            while (currentList != null) {
                currentList.remove(this);
                currentList = this.list;
            }
        }

        @Override
        public int compareTo(TimerTaskEntry o) {
            return Long.compare(this.expirationMs, o.expirationMs);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TimerTaskEntry)) {
                return false;
            }
            TimerTaskEntry other = (TimerTaskEntry)obj;
            return this.compareTo(other) == 0 && this.list == other.list && this.next == other.next && this.prev == other.prev && this.timerTask == other.timerTask;
        }

        public TimerTask timerTask() {
            return this.timerTask;
        }

        public long expirationMs() {
            return this.expirationMs;
        }
    }
}

