/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.utils.timer;

import io.streamnative.pulsar.handlers.kop.utils.timer.TimerTaskList;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class TimingWheel {
    private final long tickMs;
    private final int wheelSize;
    private final long startMs;
    private final AtomicInteger taskCounter;
    private final DelayQueue<TimerTaskList> queue;
    private final long interval;
    private final List<TimerTaskList> buckets;
    private long currentTime;
    private volatile TimingWheel overflowWheel = null;

    public TimingWheel(long tickMs, int wheelSize, long startMs, AtomicInteger taskCounter, DelayQueue<TimerTaskList> queue) {
        this.tickMs = tickMs;
        this.wheelSize = wheelSize;
        this.startMs = startMs;
        this.taskCounter = taskCounter;
        this.queue = queue;
        this.interval = tickMs * (long)wheelSize;
        this.buckets = IntStream.range(0, wheelSize).mapToObj(i -> new TimerTaskList(taskCounter)).collect(Collectors.toList());
        this.currentTime = startMs - startMs % tickMs;
    }

    private synchronized void addOverflowWheel() {
        if (null == this.overflowWheel) {
            this.overflowWheel = new TimingWheel(this.interval, this.wheelSize, this.currentTime, this.taskCounter, this.queue);
        }
    }

    public boolean add(TimerTaskList.TimerTaskEntry timerTaskEntry) {
        long expiration = timerTaskEntry.expirationMs();
        if (timerTaskEntry.cancelled()) {
            return false;
        }
        if (expiration < this.currentTime + this.tickMs) {
            return false;
        }
        if (expiration < this.currentTime + this.interval) {
            long virtualId = expiration / this.tickMs;
            TimerTaskList bucket = this.buckets.get((int)(virtualId % (long)this.wheelSize));
            bucket.add(timerTaskEntry);
            if (bucket.setExpiration(virtualId * this.tickMs)) {
                this.queue.offer(bucket);
            }
            return true;
        }
        if (null == this.overflowWheel) {
            this.addOverflowWheel();
        }
        return this.overflowWheel.add(timerTaskEntry);
    }

    public void advanceClock(long timeMs) {
        if (timeMs >= this.currentTime + this.tickMs) {
            this.currentTime = timeMs - timeMs % this.tickMs;
            if (null != this.overflowWheel) {
                this.overflowWheel.advanceClock(this.currentTime);
            }
        }
    }
}

