/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KopResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(KopResponseUtils.class);

    public static ByteBuf serializeResponse(short version, ResponseHeader responseHeader, AbstractResponse response) {
        return Unpooled.wrappedBuffer((ByteBuffer)response.serializeWithHeader(responseHeader, version));
    }

    public static ByteBuffer serializeRequest(RequestHeader requestHeader, AbstractRequest request) {
        return RequestUtils.serialize((Message)requestHeader.data(), (short)requestHeader.headerVersion(), (Message)request.data(), (short)request.version());
    }
}

