/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import org.apache.zookeeper.AddWatchMode;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class MockZooKeeperSession
extends ZooKeeper {
    private MockZooKeeper mockZooKeeper;
    private long sessionId = 0L;
    private static final Objenesis objenesis = new ObjenesisStd();
    private static final AtomicInteger sessionIdGenerator = new AtomicInteger(1000);
    private boolean closeMockZooKeeperOnClose;

    public static MockZooKeeperSession newInstance(MockZooKeeper mockZooKeeper) {
        return MockZooKeeperSession.newInstance(mockZooKeeper, true);
    }

    public static MockZooKeeperSession newInstance(MockZooKeeper mockZooKeeper, boolean closeMockZooKeeperOnClose) {
        ObjectInstantiator instantiator = objenesis.getInstantiatorOf(MockZooKeeperSession.class);
        MockZooKeeperSession mockZooKeeperSession = (MockZooKeeperSession)((Object)instantiator.newInstance());
        mockZooKeeperSession.mockZooKeeper = mockZooKeeper;
        mockZooKeeperSession.sessionId = sessionIdGenerator.getAndIncrement();
        mockZooKeeperSession.closeMockZooKeeperOnClose = closeMockZooKeeperOnClose;
        return mockZooKeeperSession;
    }

    private MockZooKeeperSession(String quorum) throws Exception {
        super(quorum, 1, event -> {});
        assert (false);
    }

    public int getSessionTimeout() {
        return this.mockZooKeeper.getSessionTimeout();
    }

    public ZooKeeper.States getState() {
        return this.mockZooKeeper.getState();
    }

    public void register(Watcher watcher) {
        this.mockZooKeeper.register(watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        try {
            this.mockZooKeeper.overrideEpheralOwner(this.getSessionId());
            String string = this.mockZooKeeper.create(path, data, acl, createMode);
            return string;
        }
        finally {
            this.mockZooKeeper.removeEpheralOwnerOverride();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        try {
            this.mockZooKeeper.overrideEpheralOwner(this.getSessionId());
            this.mockZooKeeper.create(path, data, acl, createMode, cb, ctx);
        }
        finally {
            this.mockZooKeeper.removeEpheralOwnerOverride();
        }
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException {
        return this.mockZooKeeper.getData(path, watcher, stat);
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.mockZooKeeper.getData(path, watch, cb, ctx);
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.mockZooKeeper.getData(path, watcher, cb, ctx);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.mockZooKeeper.getChildren(path, watcher, cb, ctx);
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException {
        return this.mockZooKeeper.getChildren(path, watcher);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.mockZooKeeper.getChildren(path, watch);
    }

    public void getChildren(String path, boolean watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.mockZooKeeper.getChildren(path, watcher, cb, ctx);
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.mockZooKeeper.exists(path, watch);
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.mockZooKeeper.exists(path, watcher);
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.mockZooKeeper.exists(path, watch, cb, ctx);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.mockZooKeeper.exists(path, watcher, cb, ctx);
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.mockZooKeeper.sync(path, cb, ctx);
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.mockZooKeeper.setData(path, data, version);
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.mockZooKeeper.setData(path, data, version, cb, ctx);
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.mockZooKeeper.delete(path, version);
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this.mockZooKeeper.delete(path, version, cb, ctx);
    }

    public void multi(Iterable<Op> ops, AsyncCallback.MultiCallback cb, Object ctx) {
        this.mockZooKeeper.multi(ops, cb, ctx);
    }

    public List<OpResult> multi(Iterable<Op> ops) throws InterruptedException, KeeperException {
        return this.mockZooKeeper.multi(ops);
    }

    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode, AsyncCallback.VoidCallback cb, Object ctx) {
        this.mockZooKeeper.addWatch(basePath, watcher, mode, cb, ctx);
    }

    public void addWatch(String basePath, Watcher watcher, AddWatchMode mode) throws KeeperException, InterruptedException {
        this.mockZooKeeper.addWatch(basePath, watcher, mode);
    }

    public void addWatch(String basePath, AddWatchMode mode) throws KeeperException, InterruptedException {
        this.mockZooKeeper.addWatch(basePath, mode);
    }

    public void addWatch(String basePath, AddWatchMode mode, AsyncCallback.VoidCallback cb, Object ctx) {
        this.mockZooKeeper.addWatch(basePath, mode, cb, ctx);
    }

    public void close() throws InterruptedException {
        if (this.closeMockZooKeeperOnClose) {
            this.mockZooKeeper.close();
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.closeMockZooKeeperOnClose) {
            this.mockZooKeeper.shutdown();
        }
    }

    Optional<KeeperException.Code> programmedFailure(MockZooKeeper.Op op, String path) {
        return this.mockZooKeeper.programmedFailure(op, path);
    }

    void maybeThrowProgrammedFailure(MockZooKeeper.Op op, String path) throws KeeperException {
        this.mockZooKeeper.maybeThrowProgrammedFailure(op, path);
    }

    public void failConditional(KeeperException.Code rc, BiPredicate<MockZooKeeper.Op, String> predicate) {
        this.mockZooKeeper.failConditional(rc, predicate);
    }

    public void setAlwaysFail(KeeperException.Code rc) {
        this.mockZooKeeper.setAlwaysFail(rc);
    }

    public void unsetAlwaysFail() {
        this.mockZooKeeper.unsetAlwaysFail();
    }

    public void setSessionId(long id) {
        this.sessionId = id;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return "MockZooKeeperSession{sessionId=" + this.sessionId + "}";
    }
}

