/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import com.google.common.io.CountingInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.bookkeeper.mledger.offload.jcloud.DataBlockHeader;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;

public class DataBlockHeaderImpl
implements DataBlockHeader {
    static final int MAGIC_WORD = -69489717;
    private static final int HEADER_MAX_SIZE = 128;
    private static final int HEADER_BYTES_USED = 28;
    private static final byte[] PADDING = new byte[100];
    private final long headerLength;
    private final long blockLength;
    private final long firstEntryId;

    public static DataBlockHeaderImpl of(int blockLength, long firstEntryId) {
        return new DataBlockHeaderImpl(128L, blockLength, firstEntryId);
    }

    public static DataBlockHeader fromStream(InputStream stream) throws IOException {
        CountingInputStream countingStream = new CountingInputStream(stream);
        DataInputStream dis = new DataInputStream((InputStream)countingStream);
        int magic = dis.readInt();
        if (magic != -69489717) {
            throw new IOException("Data block header magic word not match. read: " + magic + " expected: " + -69489717);
        }
        long headerLen = dis.readLong();
        long blockLen = dis.readLong();
        long firstEntryId = dis.readLong();
        long toSkip = headerLen - countingStream.getCount();
        if (dis.skip(toSkip) != toSkip) {
            throw new EOFException("Header was too small");
        }
        return new DataBlockHeaderImpl(headerLen, blockLen, firstEntryId);
    }

    public static int getBlockMagicWord() {
        return -69489717;
    }

    public static int getDataStartOffset() {
        return 128;
    }

    @Override
    public long getBlockLength() {
        return this.blockLength;
    }

    @Override
    public long getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public long getFirstEntryId() {
        return this.firstEntryId;
    }

    public DataBlockHeaderImpl(long headerLength, long blockLength, long firstEntryId) {
        this.headerLength = headerLength;
        this.blockLength = blockLength;
        this.firstEntryId = firstEntryId;
    }

    @Override
    public InputStream toStream() {
        ByteBuf out = PulsarByteBufAllocator.DEFAULT.buffer(128, 128);
        out.writeInt(-69489717).writeLong(this.headerLength).writeLong(this.blockLength).writeLong(this.firstEntryId).writeBytes(PADDING);
        return new ByteBufInputStream(out, true);
    }

    public String toString() {
        return String.format("DataBlockHeader(len:%d,hlen:%d,firstEntry:%d)", this.blockLength, this.headerLength, this.firstEntryId);
    }
}

