/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.container;

import io.streamzi.openshift.dataflow.annotations.CloudEventConsumer;
import io.streamzi.openshift.dataflow.container.config.EnvironmentResolver;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class CloudEventInput {
    private static final Logger logger = Logger.getLogger(CloudEventInput.class.getName());
    protected Object consumerObject;
    protected Method consumerMethod;
    protected String inputName;
    protected String processorUuid;

    public CloudEventInput(Object consumerObject, Method consumerMethod) {
        this.consumerObject = consumerObject;
        this.consumerMethod = consumerMethod;
        this.processorUuid = EnvironmentResolver.get("STREAMZI_NODE_UUID");
        CloudEventConsumer consumerAnnotation = consumerMethod.getAnnotation(CloudEventConsumer.class);
        if (consumerAnnotation != null) {
            this.inputName = consumerAnnotation.name();
            logger.info("CloudEventInput configured for input name: " + this.inputName);
        }
    }

    public abstract void startInput();

    public abstract void stopInput();
}

