/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.container;

import io.streamzi.openshift.dataflow.annotations.CloudEventComponentTimer;
import io.streamzi.openshift.dataflow.annotations.CloudEventConsumer;
import io.streamzi.openshift.dataflow.annotations.CloudEventProducer;
import io.streamzi.openshift.dataflow.container.CloudEventInput;
import io.streamzi.openshift.dataflow.container.CloudEventOutput;
import io.streamzi.openshift.dataflow.container.CloudEventTimer;
import io.streamzi.openshift.dataflow.container.kafka.KafkaCloudEventInputImpl;
import io.streamzi.openshift.dataflow.container.kafka.KafkaCloudEventOutputImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessorContainer {
    private static final Logger logger = Logger.getLogger(ProcessorContainer.class.getName());
    private List<CloudEventOutput> outputs = new ArrayList<CloudEventOutput>();
    private List<CloudEventInput> inputs = new ArrayList<CloudEventInput>();
    private List<CloudEventTimer> timers = new ArrayList<CloudEventTimer>();
    private Class processorClass;
    private Object processorObject;

    public ProcessorContainer(Class processorClass) {
        this.processorClass = processorClass;
        this.setupProcessor();
    }

    private void setupProcessor() {
        try {
            Method[] methods;
            Field[] fields;
            this.processorObject = this.processorClass.newInstance();
            logger.info("Created processor: " + this.processorObject.getClass().getName());
            for (Field f : fields = this.processorClass.getDeclaredFields()) {
                if (f.getAnnotation(CloudEventProducer.class) == null) continue;
                CloudEventProducer producerAnnotation = f.getAnnotation(CloudEventProducer.class);
                logger.info("Found producer field: " + f.getName());
                f.setAccessible(true);
                KafkaCloudEventOutputImpl output = new KafkaCloudEventOutputImpl(this.processorObject, producerAnnotation.name());
                f.set(this.processorObject, output);
                this.outputs.add(output);
            }
            for (Method m : methods = this.processorClass.getDeclaredMethods()) {
                if (m.getAnnotation(CloudEventConsumer.class) != null) {
                    logger.info("Found consumer method: " + m.getName());
                    KafkaCloudEventInputImpl input = new KafkaCloudEventInputImpl(this.processorObject, m);
                    this.inputs.add(input);
                }
                if (m.getAnnotation(CloudEventComponentTimer.class) == null) continue;
                logger.info("Found timer method: " + m.getName());
                CloudEventTimer timer = new CloudEventTimer(this.processorObject, m);
                this.timers.add(timer);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error setting up processor: " + e.getMessage(), e);
        }
    }

    public void startProcessor() {
        for (CloudEventOutput output : this.outputs) {
            output.startOutput();
        }
        for (CloudEventInput input : this.inputs) {
            input.startInput();
        }
        for (CloudEventTimer timer : this.timers) {
            timer.startTimer();
        }
    }

    public void stopProcessor() {
    }
}

