/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap;

import __redirected.__JAXPRedirected;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.modules.Module;
import org.wildfly.swarm.bootstrap.MainInvoker;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.modules.BootModuleLoader;
import org.wildfly.swarm.bootstrap.performance.Performance;

public class Main {
    public static final String MAIN_PROCESS_FILE = "org.wildfly.swarm.mainProcessFile";
    private static WatchService watcher;
    private static ExecutorService shutdownService;
    private static MainInvoker mainInvoker;
    private final String[] args;

    public Main(String ... args) throws Throwable {
        this.args = args;
    }

    public static void main(String ... args) throws Throwable {
        try {
            Performance.start();
            System.setProperty("swarm.isuberjar", Boolean.TRUE.toString());
            String processFile = System.getProperty(MAIN_PROCESS_FILE);
            if (processFile != null) {
                shutdownService = Executors.newSingleThreadExecutor();
                shutdownService.submit(() -> {
                    File uuidFile = new File(processFile);
                    try {
                        File watchedDir = uuidFile.getParentFile();
                        Main.register(watchedDir);
                        Main.processEvents(watchedDir, uuidFile.toPath());
                        if (mainInvoker != null) {
                            mainInvoker.stop();
                        }
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return null;
                });
            }
            new Main(args).run();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private static void register(File directory) throws IOException {
        watcher = FileSystems.getDefault().newWatchService();
        directory.toPath().register(watcher, StandardWatchEventKinds.ENTRY_DELETE);
    }

    private static void processEvents(File watchedDir, Path file) {
        WatchKey key;
        boolean valid;
        do {
            try {
                key = watcher.take();
            }
            catch (InterruptedException x) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                Path child = watchedDir.toPath().resolve(name);
                if (kind != StandardWatchEventKinds.ENTRY_DELETE || !child.equals(file)) continue;
                return;
            }
        } while (valid = key.reset());
    }

    public void run() throws Throwable {
        this.setupBootModuleLoader();
        __JAXPRedirected.changeAll("swarm.container", Module.getBootModuleLoader());
        mainInvoker = new MainInvoker(ApplicationEnvironment.get().getMainClassName(), this.args);
        mainInvoker.invoke();
    }

    public void setupBootModuleLoader() {
        System.setProperty("boot.module.loader", BootModuleLoader.class.getName());
    }
}

