/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift;

import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.streamzi.openshift.ClientContainer;
import io.streamzi.openshift.dataflow.crds.Cloud;
import io.streamzi.openshift.dataflow.crds.CloudList;
import io.streamzi.openshift.dataflow.crds.DoneableCloud;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;

@Singleton(name="ClientContainerBean")
public class ClientContainerBean
implements ClientContainer {
    private static final Logger logger = Logger.getLogger(ClientContainerBean.class.getName());
    private final Map<String, OpenShiftClient> apiClients = new HashMap();

    @PostConstruct
    public void init() {
        logger.info("Starting ClientContainer");
        DefaultOpenShiftClient osClient = new DefaultOpenShiftClient();
        logger.info("Local OpenShift URL: " + osClient.getOpenshiftUrl().toString());
        logger.info("Local OpenShift Namespace: " + osClient.getNamespace());
        this.apiClients.put("default", osClient);
        CustomResourceDefinition cloudCRD = (CustomResourceDefinition)((Resource)osClient.customResourceDefinitions().withName("clouds.streamzi.io")).get();
        if (cloudCRD == null) {
            logger.info("Can't find Cloud CRDs - Local OpenShift only");
            return;
        }
        ((CloudList)((NonNamespaceOperation)osClient.customResources(cloudCRD, Cloud.class, CloudList.class, DoneableCloud.class).inNamespace(osClient.getNamespace())).list()).getItems().forEach(cloud -> {
            ConfigBuilder configBuilder = new ConfigBuilder();
            configBuilder.withMasterUrl("https://" + cloud.getSpec().getHostname() + ":" + cloud.getSpec().getPort());
            configBuilder.withOauthToken(cloud.getSpec().getToken());
            configBuilder.withNamespace(cloud.getSpec().getNamespace());
            DefaultOpenShiftClient client = new DefaultOpenShiftClient(configBuilder.build());
            this.apiClients.put(cloud.getMetadata().getName(), client);
            logger.info("OpenShift URL (" + cloud.getMetadata().getName() + "): " + client.getOpenshiftUrl().toString());
            logger.info("OpenShift Namespace(" + cloud.getMetadata().getName() + "): " + client.getNamespace());
        });
    }

    @PreDestroy
    public void cleanup() {
        logger.info("Stopping ClientContainer");
    }

    public String getNamespace() {
        return this.getOSClient().getNamespace();
    }

    public OpenShiftClient getOSClient() {
        return (OpenShiftClient)this.apiClients.get("default");
    }

    public Set<String> getOSClientNames() {
        return this.apiClients.keySet();
    }

    public OpenShiftClient getOSClient(String name) {
        return (OpenShiftClient)this.apiClients.get(name);
    }
}

