/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.streamzi.openshift.dataflow.model.ProcessorConstants;
import io.streamzi.openshift.dataflow.model.ProcessorFlow;
import io.streamzi.openshift.dataflow.model.ProcessorLink;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import io.streamzi.openshift.dataflow.model.ProcessorPort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DeploymentConfigBuilder {
    private static final Logger logger = Logger.getLogger(DeploymentConfigBuilder.class.getName());
    private ProcessorFlow flow;
    private String namespace;
    private final String kafkaClusterName = "my-cluster";
    private final List<ConfigMap> topicMaps = new ArrayList<ConfigMap>();
    private final String registryAddress = "docker.io";

    public DeploymentConfigBuilder(String namespace, ProcessorFlow flow) {
        this.flow = flow;
        this.namespace = namespace;
    }

    public List<ConfigMap> getTopicMaps() {
        return this.topicMaps;
    }

    public Set<String> getTopicMapNames() {
        return this.topicMaps.stream().map(topicMap -> topicMap.getMetadata().getName()).collect(Collectors.toSet());
    }

    public List<DeploymentConfig> buildDeploymentConfigs() {
        HashMap<String, DeploymentConfig> deploymentConfigs = new HashMap<String, DeploymentConfig>();
        this.populateTopicMaps();
        for (ProcessorNode node : this.flow.getNodes()) {
            if (node.getProcessorType() != ProcessorConstants.ProcessorType.DEPLOYABLE_IMAGE) continue;
            String dcName = this.flow.getName() + "-" + this.sanitisePodName(node.getDisplayName()) + "-" + node.getUuid().substring(0, 6);
            Container container = this.populateNodeDeployments(node);
            DeploymentConfig dc = ((io.fabric8.openshift.api.model.DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((io.fabric8.openshift.api.model.DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new io.fabric8.openshift.api.model.DeploymentConfigBuilder().withNewMetadata().withName(dcName)).withNamespace(this.namespace)).addToLabels("app", this.flow.getName())).addToLabels("streamzi/type", "processor-flow")).endMetadata()).withNewSpec().withReplicas(1)).addNewTrigger().withType("ConfigChange")).endTrigger()).withNewTemplate().withNewMetadata().addToLabels("app", this.flow.getName())).endMetadata()).withNewSpec().addNewContainerLike(container).endContainer()).endSpec()).endTemplate()).endSpec()).build();
            deploymentConfigs.put(dcName, dc);
        }
        return new ArrayList<DeploymentConfig>(deploymentConfigs.values());
    }

    private Container populateNodeDeployments(ProcessorNode node) {
        String topicName;
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        envVars.add(new EnvVar(this.sanitiseEnvVar("STREAMZI_NODE_UUID"), node.getUuid(), null));
        for (String key : node.getSettings().keySet()) {
            envVars.add(new EnvVar(this.sanitiseEnvVar(key), node.getSettings().get(key), null));
        }
        for (String key : node.getParent().getGlobalSettings().keySet()) {
            envVars.add(new EnvVar(this.sanitiseEnvVar(key), node.getParent().getGlobalSettings().get(key), null));
        }
        for (ProcessorPort processorPort : node.getInputs().values()) {
            for (ProcessorLink link : processorPort.getLinks()) {
                ProcessorNode sourceNode = link.getSource().getParent();
                if (sourceNode.getProcessorType() == ProcessorConstants.ProcessorType.TOPIC_ENDPOINT) {
                    envVars.add(new EnvVar(this.sanitiseEnvVar(processorPort.getName()), link.getSource().getName(), null));
                    continue;
                }
                topicName = this.flow.getName() + "-" + link.getSource().getParent().getUuid() + "-" + link.getSource().getName();
                envVars.add(new EnvVar(this.sanitiseEnvVar(processorPort.getName()), topicName, null));
            }
        }
        for (ProcessorOutputPort processorOutputPort : node.getOutputs().values()) {
            topicName = this.flow.getName() + "-" + node.getUuid() + "-" + processorOutputPort.getName();
            envVars.add(new EnvVar(this.sanitiseEnvVar(processorOutputPort.getName()), topicName, null));
        }
        return ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(node.getParent().getName())).withImage("docker.io/" + node.getImageName())).withImagePullPolicy("IfNotPresent")).withEnv(envVars)).build();
    }

    private void populateTopicMaps() {
        ConfigMap cm = new ConfigMap();
        for (ProcessorLink link : this.flow.getLinks()) {
            logger.info("Processing link");
            ProcessorNode sourceNode = link.getSource().getParent();
            if (sourceNode.getProcessorType() != ProcessorConstants.ProcessorType.DEPLOYABLE_IMAGE) continue;
            String topicName = this.flow.getName() + "-" + link.getSource().getParent().getUuid() + "-" + link.getSource().getName();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("name", topicName);
            data.put("partitions", "2");
            data.put("replicas", "1");
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put("strimzi.io/cluster", "my-cluster");
            labels.put("strimzi.io/kind", "topic");
            labels.put("streamzi.io/source", "autocreated");
            labels.put("app", this.flow.getName());
            ObjectMeta om = new ObjectMeta();
            om.setName(topicName);
            om.setNamespace(this.namespace);
            om.setLabels(labels);
            cm.setMetadata(om);
            cm.setData(data);
            this.topicMaps.add(cm);
        }
    }

    private String sanitiseEnvVar(String source) {
        return source.replace("-", "_").replace(".", "_").toUpperCase();
    }

    private String sanitisePodName(String source) {
        return source.replace(" ", "-").replace("/", "-").toLowerCase();
    }
}

