/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.streamzi.openshift.DeploymentConfigBuilder;
import io.streamzi.openshift.dataflow.model.ProcessorFlow;
import io.streamzi.openshift.dataflow.model.crds.DoneableFlow;
import io.streamzi.openshift.dataflow.model.crds.Flow;
import io.streamzi.openshift.dataflow.model.crds.FlowList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FlowController {
    private static Logger logger = Logger.getLogger(FlowController.class.getName());
    private OpenShiftClient osClient = new DefaultOpenShiftClient();

    public void onAdded(Flow flow) {
        this.createOrUpdate(flow);
    }

    public void onModified(Flow flow) {
        this.createOrUpdate(flow);
    }

    public void onDeleted(Flow flow) {
        this.delete(flow);
    }

    private void createOrUpdate(Flow customResource) {
        try {
            ProcessorFlow flow = new ProcessorFlow(customResource.getSpec());
            logger.info("Flow Parsed OK");
            DeploymentConfigBuilder deployer = new DeploymentConfigBuilder(this.osClient.getNamespace(), flow);
            List<DeploymentConfig> deploymentConfigs = deployer.buildDeploymentConfigs();
            for (DeploymentConfig dc2 : deploymentConfigs) {
                for (ConfigMap map : deployer.getTopicMaps()) {
                    logger.info("Creating ConfigMap: " + map.getMetadata().getName());
                    logger.info(map.toString());
                    ((Resource)((NonNamespaceOperation)this.osClient.configMaps().inNamespace(map.getMetadata().getNamespace())).withName(map.getMetadata().getName())).createOrReplace(map);
                }
                dc2.getSpec().getTemplate().getSpec().getContainers().stream().filter(container -> container.getEnv() != null && container.getEnv().size() > 0).forEach(container -> {
                    String cmName = dc2.getMetadata().getName() + "-ev.cm";
                    String namespace = dc2.getMetadata().getNamespace();
                    HashMap<String, String> labels = new HashMap<String, String>();
                    labels.put("streamzi.io/kind", "ev");
                    labels.put("streamzi.io/target", dc2.getMetadata().getName());
                    labels.put("app", flow.getName());
                    ObjectMeta om = new ObjectMeta();
                    om.setName(cmName);
                    om.setNamespace(namespace);
                    om.setLabels(labels);
                    ConfigMap cm = new ConfigMap();
                    cm.setMetadata(om);
                    HashMap<String, String> cmData = new HashMap<String, String>();
                    for (EnvVar ev : container.getEnv()) {
                        cmData.put(ev.getName(), ev.getValue());
                    }
                    cm.setData(cmData);
                    deployer.getTopicMaps().add(cm);
                    ((Resource)((NonNamespaceOperation)this.osClient.configMaps().inNamespace(namespace)).withName(cmName)).createOrReplace(cm);
                    logger.info("Creating deployment: " + dc2.getMetadata().getName());
                    logger.info(dc2.toString());
                    ((NonNamespaceOperation)this.osClient.deploymentConfigs().inNamespace(dc2.getMetadata().getNamespace())).createOrReplace(dc2);
                });
            }
            Set newDeploymentConfigNames = deploymentConfigs.stream().map(dc -> dc.getMetadata().getName()).collect(Collectors.toSet());
            ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)this.osClient.deploymentConfigs().inNamespace(this.osClient.getNamespace())).withLabel("app", flow.getName())).list()).getItems().stream().filter(existingDC -> !newDeploymentConfigNames.contains(existingDC.getMetadata().getName())).forEach(existingDC -> {
                Boolean cfr_ignored_0 = (Boolean)((DeployableScalableResource)((NonNamespaceOperation)this.osClient.deploymentConfigs().inNamespace(this.osClient.getNamespace())).withName(existingDC.getMetadata().getName())).delete();
            });
            ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)this.osClient.configMaps().inNamespace(this.osClient.getNamespace())).withLabel("app", flow.getName())).list()).getItems().stream().filter(existing -> !existing.getMetadata().getLabels().containsKey("streamzi.io/kind") || !existing.getMetadata().getLabels().get("streamzi.io/kind").equals("flow")).filter(existing -> !deployer.getTopicMapNames().contains(existing.getMetadata().getName())).forEach(deleted -> {
                Boolean cfr_ignored_0 = (Boolean)((Resource)((NonNamespaceOperation)this.osClient.configMaps().inNamespace(this.osClient.getNamespace())).withName(deleted.getMetadata().getName())).delete();
            });
            if (flow.getNodes().isEmpty() && flow.getLinks().isEmpty()) {
                CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)this.osClient.customResourceDefinitions().withName("flows.streamzi.io")).get();
                ((NonNamespaceOperation)this.osClient.customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(this.osClient.getNamespace())).delete(customResource);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error parsing JSON flow data: " + e.getMessage(), e);
        }
    }

    private void delete(Flow customResource) {
        try {
            ProcessorFlow flow = new ProcessorFlow(customResource.getSpec());
            logger.info("Flow Parsed OK");
            List<DeploymentConfig> existingDCs = ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)this.osClient.deploymentConfigs().inNamespace(this.osClient.getNamespace())).withLabel("app", flow.getName())).list()).getItems();
            existingDCs.forEach(existingDC -> {
                Boolean cfr_ignored_0 = (Boolean)((DeployableScalableResource)((NonNamespaceOperation)this.osClient.deploymentConfigs().inNamespace(this.osClient.getNamespace())).withName(existingDC.getMetadata().getName())).delete();
            });
            List<ConfigMap> existingCMs = ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)this.osClient.configMaps().inNamespace(this.osClient.getNamespace())).withLabel("app", flow.getName())).list()).getItems();
            existingCMs.forEach(existing -> {
                Boolean cfr_ignored_0 = (Boolean)((Resource)((NonNamespaceOperation)this.osClient.configMaps().inNamespace(this.osClient.getNamespace())).withName(existing.getMetadata().getName())).delete();
            });
            CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)this.osClient.customResourceDefinitions().withName("flows.streamzi.io")).get();
            ((NonNamespaceOperation)this.osClient.customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(this.osClient.getNamespace())).delete(customResource);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error parsing JSON flow data: " + e.getMessage(), e);
        }
    }
}

