/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.model.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.streamzi.openshift.dataflow.model.ProcessorNodeTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public final class ProcessorTemplateYAMLReader {
    private static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory());

    private ProcessorTemplateYAMLReader() {
    }

    public static ProcessorNodeTemplate readTemplate(File yamlFile) throws Exception {
        try (FileInputStream inStream = new FileInputStream(yamlFile);){
            ProcessorNodeTemplate processorNodeTemplate = MAPPER.readValue((InputStream)inStream, ProcessorNodeTemplate.class);
            return processorNodeTemplate;
        }
    }

    public static ProcessorNodeTemplate readTemplate(String yaml) throws Exception {
        return MAPPER.readValue(yaml, ProcessorNodeTemplate.class);
    }

    public static ProcessorNodeTemplate readTemplate(InputStream src) throws Exception {
        return MAPPER.readValue(src, ProcessorNodeTemplate.class);
    }
}

