/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift.dataflow.model.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.streamzi.openshift.dataflow.model.ProcessorFlow;
import io.streamzi.openshift.dataflow.model.ProcessorLink;
import io.streamzi.openshift.dataflow.model.ProcessorNode;
import io.streamzi.openshift.dataflow.model.ProcessorOutputPort;
import io.streamzi.openshift.dataflow.model.serialization.SerializedLink;
import io.streamzi.openshift.dataflow.model.serialization.SerializedNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(using=JsonDeserializer.None.class)
public class SerializedFlow
implements KubernetesResource {
    @JsonIgnore
    private ProcessorFlow flow;
    private String name;
    private List<SerializedNode> nodes = new ArrayList<SerializedNode>();
    private List<SerializedLink> links = new ArrayList<SerializedLink>();
    private Map<String, String> settings = new HashMap<String, String>();
    private Map<String, String> globalSettings = new HashMap<String, String>();

    public SerializedFlow() {
    }

    public SerializedFlow(ProcessorFlow flow) {
        this.flow = flow;
        this.name = flow.getName();
        for (ProcessorNode n : flow.getNodes()) {
            this.nodes.add(new SerializedNode(n));
            for (ProcessorOutputPort output : n.getOutputs().values()) {
                for (ProcessorLink link : output.getLinks()) {
                    this.links.add(new SerializedLink(link));
                }
            }
        }
        for (String key : flow.getSettings().keySet()) {
            this.settings.put(key, flow.getSettings().get(key));
        }
        for (String key : flow.getGlobalSettings().keySet()) {
            this.globalSettings.put(key, flow.getGlobalSettings().get(key));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public Map<String, String> getGlobalSettings() {
        return this.globalSettings;
    }

    public void setGlobalSettings(Map<String, String> globalSettings) {
        this.globalSettings = globalSettings;
    }

    public List<SerializedNode> getNodes() {
        return this.nodes;
    }

    public List<SerializedLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<SerializedLink> links) {
        this.links = links;
    }

    public void setNodes(List<SerializedNode> nodes) {
        this.nodes = nodes;
    }

    public String toString() {
        return "SerializedFlow{flow=" + this.flow + ", name='" + this.name + '\'' + ", nodes=" + this.nodes + ", links=" + this.links + ", settings=" + this.settings + ", globalSettings=" + this.globalSettings + '}';
    }
}

