/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift;

import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.streamzi.openshift.dataflow.crds.Cloud;
import io.streamzi.openshift.dataflow.crds.CloudList;
import io.streamzi.openshift.dataflow.crds.DoneableCloud;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ClientCache {
    private static Logger logger = Logger.getLogger(ClientCache.class.getName());
    private static final Map<String, OpenShiftClient> apiClients = new HashMap<String, OpenShiftClient>();
    private static final Map<String, String> bootstrapServerCache = new HashMap<String, String>();

    public static OpenShiftClient getClient() {
        return apiClients.get("local");
    }

    public static OpenShiftClient getClient(String name) {
        return apiClients.get(name);
    }

    public static Set<String> getClientNames() {
        return apiClients.keySet();
    }

    public static Map<String, String> getBootstrapServerCache() {
        return bootstrapServerCache;
    }

    static {
        DefaultOpenShiftClient osClient = new DefaultOpenShiftClient();
        logger.info("Local OpenShift URL: " + osClient.getOpenshiftUrl().toString());
        logger.info("Local OpenShift Namespace: " + osClient.getNamespace());
        apiClients.put("local", osClient);
        CustomResourceDefinition cloudCRD = (CustomResourceDefinition)((Resource)osClient.customResourceDefinitions().withName("clouds.streamzi.io")).get();
        if (cloudCRD == null) {
            logger.info("Can't find Cloud CRDs - Local OpenShift only");
        } else {
            ((CloudList)((NonNamespaceOperation)osClient.customResources(cloudCRD, Cloud.class, CloudList.class, DoneableCloud.class).inNamespace(osClient.getNamespace())).list()).getItems().forEach(cloud -> {
                ConfigBuilder configBuilder = new ConfigBuilder();
                configBuilder.withMasterUrl("https://" + cloud.getSpec().getHostname() + ":" + cloud.getSpec().getPort());
                configBuilder.withOauthToken(cloud.getSpec().getToken());
                configBuilder.withNamespace(cloud.getSpec().getNamespace());
                DefaultOpenShiftClient client = new DefaultOpenShiftClient(configBuilder.build());
                apiClients.put(cloud.getMetadata().getName(), client);
                bootstrapServerCache.put(cloud.getMetadata().getName(), cloud.getSpec().getBootstrapServers());
                logger.info("OpenShift URL (" + cloud.getMetadata().getName() + "): " + client.getOpenshiftUrl().toString());
                logger.info("OpenShift Namespace(" + cloud.getMetadata().getName() + "): " + client.getNamespace());
            });
        }
    }
}

