/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.openshift;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.streamzi.openshift.ClientCache;
import io.streamzi.openshift.FlowController;
import io.streamzi.openshift.dataflow.crds.DoneableFlow;
import io.streamzi.openshift.dataflow.crds.Flow;
import io.streamzi.openshift.dataflow.crds.FlowList;
import java.util.logging.Logger;

public class FlowWatcher
implements Watcher<Flow>,
Runnable {
    private static final Logger logger = Logger.getLogger(FlowWatcher.class.getName());
    private FlowController controller;

    public FlowWatcher(FlowController controller) {
        this.controller = controller;
    }

    @Override
    public void eventReceived(Watcher.Action action, Flow flow) {
        ObjectMeta metadata = flow.getMetadata();
        String name = metadata.getName();
        logger.fine("Flow watch received event " + (Object)((Object)action) + " on Custom Resource " + name);
        try {
            switch (action) {
                case ADDED: {
                    this.controller.onAdded(flow);
                    break;
                }
                case MODIFIED: {
                    this.controller.onModified(flow);
                    break;
                }
                case DELETED: {
                    this.controller.onDeleted(flow);
                    break;
                }
                case ERROR: {
                    logger.warning("Watch received action=ERROR for Flow " + name);
                }
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
    }

    @Override
    public void run() {
        logger.info("Starting FlowWatcher");
        CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)ClientCache.getClient().customResourceDefinitions().withName("flows.streamzi.io")).get();
        ((NonNamespaceOperation)ClientCache.getClient().customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(ClientCache.getClient().getNamespace())).watch(this);
    }

    @Override
    public void onClose(KubernetesClientException e) {
        logger.info("Closing Watcher: " + this);
        logger.info(e.getMessage());
    }
}

