/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Initializers;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectMetaFluentImpl<A extends ObjectMetaFluent<A>>
extends BaseFluent<A>
implements ObjectMetaFluent<A> {
    private Map<String, String> annotations;
    private String clusterName;
    private String creationTimestamp;
    private Long deletionGracePeriodSeconds;
    private String deletionTimestamp;
    private List<String> finalizers;
    private String generateName;
    private Long generation;
    private Initializers initializers;
    private Map<String, String> labels;
    private String name;
    private String namespace;
    private List<OwnerReference> ownerReferences;
    private String resourceVersion;
    private String selfLink;
    private String uid;

    public ObjectMetaFluentImpl() {
    }

    public ObjectMetaFluentImpl(ObjectMeta instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withClusterName(instance.getClusterName());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withInitializers(instance.getInitializers());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public A withAnnotations(Map<String, String> annotations) {
        if (this.annotations == null) {
            this.annotations = new LinkedHashMap<String, String>();
        } else {
            this.annotations.clear();
        }
        if (annotations != null) {
            this.annotations.putAll(annotations);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public A withClusterName(String clusterName) {
        this.clusterName = clusterName;
        return (A)this;
    }

    @Override
    public Boolean hasClusterName() {
        return this.clusterName != null;
    }

    @Override
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public A withCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCreationTimestamp() {
        return this.creationTimestamp != null;
    }

    @Override
    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    @Override
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds != null;
    }

    @Override
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    public A withDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionTimestamp() {
        return this.deletionTimestamp != null;
    }

    @Override
    public A addToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFinalizers(int index, String item) {
        this.finalizers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFinalizers(Collection<String> items) {
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    @Override
    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    @Override
    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    @Override
    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.finalizers);
            this.finalizers.clear();
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        this.finalizers.clear();
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)this;
    }

    @Override
    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    public Initializers getInitializers() {
        return this.initializers;
    }

    @Override
    public A withInitializers(Initializers initializers) {
        this.initializers = initializers;
        return (A)this;
    }

    @Override
    public Boolean hasInitializers() {
        return this.initializers != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, String>();
        } else {
            this.labels.clear();
        }
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A addToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        }
        this.ownerReferences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOwnerReferences(int index, OwnerReference item) {
        this.ownerReferences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOwnerReferences(OwnerReference ... items) {
        for (OwnerReference item : items) {
            this.ownerReferences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwnerReferences(Collection<OwnerReference> items) {
        for (OwnerReference item : items) {
            this.ownerReferences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwnerReferences(OwnerReference ... items) {
        for (OwnerReference item : items) {
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwnerReferences(Collection<OwnerReference> items) {
        for (OwnerReference item : items) {
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<OwnerReference> getOwnerReferences() {
        return this.ownerReferences;
    }

    @Override
    public OwnerReference getOwnerReference(int index) {
        return this.ownerReferences.get(index);
    }

    @Override
    public OwnerReference getFirstOwnerReference() {
        return this.ownerReferences.get(0);
    }

    @Override
    public OwnerReference getLastOwnerReference() {
        return this.ownerReferences.get(this.ownerReferences.size() - 1);
    }

    @Override
    public OwnerReference getMatchingOwnerReference(Predicate<OwnerReference> predicate) {
        for (OwnerReference item : this.ownerReferences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withOwnerReferences(List<OwnerReference> ownerReferences) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList<OwnerReference>();
        } else {
            this._visitables.removeAll(this.ownerReferences);
            this.ownerReferences.clear();
        }
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withOwnerReferences(OwnerReference ... ownerReferences) {
        this.ownerReferences.clear();
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwnerReferences() {
        return this.ownerReferences != null && !this.ownerReferences.isEmpty();
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    @Override
    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    @Override
    public String getSelfLink() {
        return this.selfLink;
    }

    @Override
    public A withSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return (A)this;
    }

    @Override
    public Boolean hasSelfLink() {
        return this.selfLink != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetaFluentImpl that = (ObjectMetaFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.creationTimestamp != null ? !this.creationTimestamp.equals(that.creationTimestamp) : that.creationTimestamp != null) {
            return false;
        }
        if (this.deletionGracePeriodSeconds != null ? !this.deletionGracePeriodSeconds.equals(that.deletionGracePeriodSeconds) : that.deletionGracePeriodSeconds != null) {
            return false;
        }
        if (this.deletionTimestamp != null ? !this.deletionTimestamp.equals(that.deletionTimestamp) : that.deletionTimestamp != null) {
            return false;
        }
        if (this.finalizers != null ? !this.finalizers.equals(that.finalizers) : that.finalizers != null) {
            return false;
        }
        if (this.generateName != null ? !this.generateName.equals(that.generateName) : that.generateName != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.initializers != null ? !this.initializers.equals(that.initializers) : that.initializers != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.ownerReferences != null ? !this.ownerReferences.equals(that.ownerReferences) : that.ownerReferences != null) {
            return false;
        }
        if (this.resourceVersion != null ? !this.resourceVersion.equals(that.resourceVersion) : that.resourceVersion != null) {
            return false;
        }
        if (this.selfLink != null ? !this.selfLink.equals(that.selfLink) : that.selfLink != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }
}

