/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.client.Callback;
import io.fabric8.kubernetes.client.utils.InputStreamPumper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonBlockingInputStreamPumper
extends InputStreamPumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamReader.class);

    public NonBlockingInputStreamPumper(InputStream in, Callback<byte[]> callback) {
        this(in, callback, null);
    }

    public NonBlockingInputStreamPumper(InputStream in, Callback<byte[]> callback, Runnable onClose) {
        super(in, callback, onClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NonBlockingInputStreamPumper nonBlockingInputStreamPumper = this;
        synchronized (nonBlockingInputStreamPumper) {
            this.thread = Thread.currentThread();
        }
        byte[] buffer = new byte[1024];
        try {
            while (this.keepReading && !Thread.currentThread().isInterrupted()) {
                while (this.in.available() > 0 && this.keepReading && !Thread.currentThread().isInterrupted()) {
                    int length = this.in.read(buffer);
                    if (length < 0) {
                        throw new IOException("EOF has been reached!");
                    }
                    byte[] actual = new byte[length];
                    System.arraycopy(buffer, 0, actual, 0, length);
                    this.callback.call(actual);
                }
                Thread.sleep(50L);
            }
        }
        catch (IOException e) {
            if (!this.keepReading) {
                return;
            }
            if (!this.thread.isInterrupted()) {
                LOGGER.error("Error while pumping stream.", e);
            } else {
                LOGGER.debug("Interrupted while pumping stream.");
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

