/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.eventflow;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.streamzi.eventflow.ClientCache;
import io.streamzi.eventflow.crds.DoneableFlow;
import io.streamzi.eventflow.crds.Flow;
import io.streamzi.eventflow.crds.FlowList;
import io.streamzi.eventflow.deployment.TargetState;
import io.streamzi.eventflow.model.ProcessorFlow;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.model.DoneableKafkaTopic;
import io.strimzi.api.kafka.model.KafkaTopic;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlowController {
    private static Logger logger = Logger.getLogger(FlowController.class.getName());

    public void onAdded(Flow flow) {
        this.createOrUpdate(flow);
    }

    public void onModified(Flow flow) {
        this.createOrUpdate(flow);
    }

    public void onDeleted(Flow flow) {
        this.delete(flow);
    }

    private void createOrUpdate(Flow customResource) {
        try {
            ProcessorFlow flow = new ProcessorFlow(customResource.getSpec());
            logger.info("Flow Parsed OK");
            flow.getCloudNames().forEach(cloudName -> {
                OpenShiftClient client = ClientCache.getClient(cloudName);
                if (client != null) {
                    TargetState target = new TargetState((String)cloudName, flow, ClientCache.getBootstrapServerCache());
                    target.build();
                    target.getTopicCrds().forEach(cr -> {
                        KafkaTopic cfr_ignored_0 = (KafkaTopic)((Resource)((NonNamespaceOperation)client.customResources(Crds.topic(), KafkaTopic.class, KafkaTopicList.class, DoneableKafkaTopic.class).inNamespace(client.getNamespace())).withName(cr.getMetadata().getName())).createOrReplace((KafkaTopic)cr);
                    });
                    target.getDeploymentConfigs().forEach(dc -> {
                        DeploymentConfig cfr_ignored_0 = (DeploymentConfig)((DeployableScalableResource)((NonNamespaceOperation)client.deploymentConfigs().inNamespace(client.getNamespace())).withName(dc.getMetadata().getName())).createOrReplace(dc);
                    });
                    target.getEvConfigMaps().forEach(cm -> {
                        ConfigMap cfr_ignored_0 = (ConfigMap)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withName(cm.getMetadata().getName())).createOrReplace(cm);
                    });
                } else {
                    logger.info("Ignoring Cloud: " + cloudName);
                }
            });
            ClientCache.getClientNames().forEach(cloudName -> {
                OpenShiftClient client = ClientCache.getClient(cloudName);
                TargetState target = new TargetState((String)cloudName, flow, ClientCache.getBootstrapServerCache());
                target.build();
                ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)client.deploymentConfigs().inNamespace(client.getNamespace())).withLabel("app", flow.getName())).list()).getItems().stream().filter(existingDC -> !target.getDeploymentConfigNames().contains(existingDC.getMetadata().getName())).forEach(existingDC -> {
                    Boolean cfr_ignored_0 = (Boolean)((DeployableScalableResource)((NonNamespaceOperation)client.deploymentConfigs().inNamespace(client.getNamespace())).withName(existingDC.getMetadata().getName())).delete();
                });
                ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withLabel("app", flow.getName())).list()).getItems().stream().filter(existing -> !existing.getMetadata().getLabels().containsKey("streamzi.io/kind") || !existing.getMetadata().getLabels().get("streamzi.io/kind").equals("flow")).filter(existing -> !target.getConfigMapNames().contains(existing.getMetadata().getName())).forEach(deleted -> {
                    Boolean cfr_ignored_0 = (Boolean)((Resource)((NonNamespaceOperation)client.configMaps().inNamespace(client.getNamespace())).withName(deleted.getMetadata().getName())).delete();
                });
                if (flow.getNodes().isEmpty() && flow.getLinks().isEmpty() && customResource.getMetadata().getNamespace().equals(client.getNamespace())) {
                    CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)client.customResourceDefinitions().withName("flows.streamzi.io")).get();
                    ((NonNamespaceOperation)client.customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(client.getNamespace())).delete(customResource);
                }
            });
            logger.info("Done");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error parsing JSON flow data: " + e.getMessage(), e);
        }
    }

    private void delete(Flow customResource) {
        try {
            ProcessorFlow flow = new ProcessorFlow(customResource.getSpec());
            logger.info("Flow Parsed OK");
            List<DeploymentConfig> existingDCs = ((DeploymentConfigList)((FilterWatchListDeletable)((NonNamespaceOperation)ClientCache.getClient().deploymentConfigs().inNamespace(ClientCache.getClient().getNamespace())).withLabel("app", flow.getName())).list()).getItems();
            existingDCs.forEach(existingDC -> {
                Boolean cfr_ignored_0 = (Boolean)((DeployableScalableResource)((NonNamespaceOperation)ClientCache.getClient().deploymentConfigs().inNamespace(ClientCache.getClient().getNamespace())).withName(existingDC.getMetadata().getName())).delete();
            });
            List<ConfigMap> existingCMs = ((ConfigMapList)((FilterWatchListDeletable)((NonNamespaceOperation)ClientCache.getClient().configMaps().inNamespace(ClientCache.getClient().getNamespace())).withLabel("app", flow.getName())).list()).getItems();
            existingCMs.forEach(existing -> {
                Boolean cfr_ignored_0 = (Boolean)((Resource)((NonNamespaceOperation)ClientCache.getClient().configMaps().inNamespace(ClientCache.getClient().getNamespace())).withName(existing.getMetadata().getName())).delete();
            });
            CustomResourceDefinition flowCRD = (CustomResourceDefinition)((Resource)ClientCache.getClient().customResourceDefinitions().withName("flows.streamzi.io")).get();
            ((NonNamespaceOperation)ClientCache.getClient().customResources(flowCRD, Flow.class, FlowList.class, DoneableFlow.class).inNamespace(ClientCache.getClient().getNamespace())).delete(customResource);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error parsing JSON flow data: " + e.getMessage(), e);
        }
    }
}

