/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.strimzi.api.kafka.model.AclOperation;
import io.strimzi.api.kafka.model.AclRuleResource;
import io.strimzi.api.kafka.model.AclRuleType;
import io.strimzi.crdgenerator.annotations.Description;
import io.vertx.core.cli.annotations.DefaultValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AclRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AclRuleType type = AclRuleType.ALLOW;
    private AclRuleResource resource;
    private String host = "*";
    private AclOperation operation;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    public AclRule() {
    }

    public AclRule(AclRuleType type, AclRuleResource resource, String host, AclOperation operation) {
        this.type = type;
        this.resource = resource;
        this.host = host;
        this.operation = operation;
    }

    @Description(value="The type of the rule.Currently the only supported type is `allow`.ACL rules with type `allow` are used to allow user to execute the specified operations. Default value is `allow`.")
    @DefaultValue(value="allow")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AclRuleType getType() {
        return this.type;
    }

    public void setType(AclRuleType type) {
        this.type = type;
    }

    @Description(value="Indicates the resource for which given ACL rule applies.")
    @JsonProperty(required=true)
    public AclRuleResource getResource() {
        return this.resource;
    }

    public void setResource(AclRuleResource resource) {
        this.resource = resource;
    }

    @Description(value="The host from which the action described in the ACL rule is allowed or denied.")
    @DefaultValue(value="*")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Description(value="Operation which will be allowed or denied. Supported operations are: Read, Write, Create, Delete, Alter, Describe, ClusterAction, AlterConfigs, DescribeConfigs, IdempotentWrite and All.")
    @JsonProperty(required=true)
    public AclOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AclOperation operation) {
        this.operation = operation;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

