/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"watchedNamespace", "image", "reconciliationIntervalSeconds", "zookeeperSessionTimeoutSeconds", "resources", "topicMetadataMaxAttempts", "logging"})
public class EntityTopicOperatorSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_IMAGE = System.getenv().getOrDefault("STRIMZI_DEFAULT_TOPIC_OPERATOR_IMAGE", "strimzi/topic-operator:latest");
    public static final int DEFAULT_REPLICAS = 1;
    public static final int DEFAULT_HEALTHCHECK_DELAY = 10;
    public static final int DEFAULT_HEALTHCHECK_TIMEOUT = 5;
    public static final int DEFAULT_ZOOKEEPER_PORT = 2181;
    public static final int DEFAULT_BOOTSTRAP_SERVERS_PORT = 9091;
    public static final int DEFAULT_FULL_RECONCILIATION_INTERVAL_SECONDS = 90;
    public static final int DEFAULT_ZOOKEEPER_SESSION_TIMEOUT_SECONDS = 20;
    public static final int DEFAULT_TOPIC_METADATA_MAX_ATTEMPTS = 6;
    protected String watchedNamespace;
    protected String image = DEFAULT_IMAGE;
    protected int reconciliationIntervalSeconds = 90;
    protected int zookeeperSessionTimeoutSeconds = 20;
    protected int topicMetadataMaxAttempts = 6;
    protected Resources resources;
    protected Logging logging;
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The namespace the Topic Operator should watch.")
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    public void setWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
    }

    @Description(value="The image to use for the Topic Operator")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Description(value="Interval between periodic reconciliations.")
    @Minimum(value=0)
    public int getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    public void setReconciliationIntervalSeconds(int reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
    }

    @Description(value="Timeout for the Zookeeper session")
    @Minimum(value=0)
    public int getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    public void setZookeeperSessionTimeoutSeconds(int zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
    }

    @Description(value="The number of attempts at getting topic metadata")
    @Minimum(value=0)
    public int getTopicMetadataMaxAttempts() {
        return this.topicMetadataMaxAttempts;
    }

    public void setTopicMetadataMaxAttempts(int topicMetadataMaxAttempts) {
        this.topicMetadataMaxAttempts = topicMetadataMaxAttempts;
    }

    @Description(value="Resource constraints (limits and requests).")
    public Resources getResources() {
        return this.resources;
    }

    @Description(value="Resource constraints (limits and requests).")
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    @Description(value="Logging configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

