/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpec;
import io.strimzi.api.kafka.model.EntityTopicOperatorSpecFluent;
import io.strimzi.api.kafka.model.ExternalLogging;
import io.strimzi.api.kafka.model.ExternalLoggingBuilder;
import io.strimzi.api.kafka.model.ExternalLoggingFluentImpl;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.InlineLoggingBuilder;
import io.strimzi.api.kafka.model.InlineLoggingFluentImpl;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.api.kafka.model.ResourcesBuilder;
import io.strimzi.api.kafka.model.ResourcesFluentImpl;

public class EntityTopicOperatorSpecFluentImpl<A extends EntityTopicOperatorSpecFluent<A>>
extends BaseFluent<A>
implements EntityTopicOperatorSpecFluent<A> {
    private String watchedNamespace;
    private String image;
    private int reconciliationIntervalSeconds;
    private int zookeeperSessionTimeoutSeconds;
    private int topicMetadataMaxAttempts;
    private ResourcesBuilder resources;
    private VisitableBuilder<? extends Logging, ?> logging;

    public EntityTopicOperatorSpecFluentImpl() {
    }

    public EntityTopicOperatorSpecFluentImpl(EntityTopicOperatorSpec instance) {
        this.withWatchedNamespace(instance.getWatchedNamespace());
        this.withImage(instance.getImage());
        this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());
        this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());
        this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());
        this.withResources(instance.getResources());
        this.withLogging(instance.getLogging());
    }

    @Override
    public String getWatchedNamespace() {
        return this.watchedNamespace;
    }

    @Override
    public A withWatchedNamespace(String watchedNamespace) {
        this.watchedNamespace = watchedNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasWatchedNamespace() {
        return this.watchedNamespace != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public int getReconciliationIntervalSeconds() {
        return this.reconciliationIntervalSeconds;
    }

    @Override
    public A withReconciliationIntervalSeconds(int reconciliationIntervalSeconds) {
        this.reconciliationIntervalSeconds = reconciliationIntervalSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasReconciliationIntervalSeconds() {
        return true;
    }

    @Override
    public int getZookeeperSessionTimeoutSeconds() {
        return this.zookeeperSessionTimeoutSeconds;
    }

    @Override
    public A withZookeeperSessionTimeoutSeconds(int zookeeperSessionTimeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = zookeeperSessionTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasZookeeperSessionTimeoutSeconds() {
        return true;
    }

    @Override
    public int getTopicMetadataMaxAttempts() {
        return this.topicMetadataMaxAttempts;
    }

    @Override
    public A withTopicMetadataMaxAttempts(int topicMetadataMaxAttempts) {
        this.topicMetadataMaxAttempts = topicMetadataMaxAttempts;
        return (A)this;
    }

    @Override
    public Boolean hasTopicMetadataMaxAttempts() {
        return true;
    }

    @Override
    @Deprecated
    public Resources getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(Resources resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public EntityTopicOperatorSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public EntityTopicOperatorSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public EntityTopicOperatorSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourcesBuilder().build());
    }

    @Override
    public EntityTopicOperatorSpecFluent.ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public Logging getLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public Logging buildLogging() {
        return this.logging != null ? (Logging)this.logging.build() : null;
    }

    @Override
    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging) {
            this.logging = new ExternalLoggingBuilder((ExternalLogging)logging);
            this._visitables.add(this.logging);
        }
        if (logging instanceof InlineLogging) {
            this.logging = new InlineLoggingBuilder((InlineLogging)logging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLogging() {
        return this.logging != null;
    }

    @Override
    public A withExternalLoggingLogging(ExternalLogging externalLoggingLogging) {
        this._visitables.remove(this.logging);
        if (externalLoggingLogging != null) {
            this.logging = new ExternalLoggingBuilder(externalLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public EntityTopicOperatorSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLogging() {
        return new ExternalLoggingLoggingNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.ExternalLoggingLoggingNested<A> withNewExternalLoggingLoggingLike(ExternalLogging item) {
        return new ExternalLoggingLoggingNestedImpl(item);
    }

    @Override
    public A withInlineLoggingLogging(InlineLogging inlineLoggingLogging) {
        this._visitables.remove(this.logging);
        if (inlineLoggingLogging != null) {
            this.logging = new InlineLoggingBuilder(inlineLoggingLogging);
            this._visitables.add(this.logging);
        }
        return (A)this;
    }

    @Override
    public EntityTopicOperatorSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLogging() {
        return new InlineLoggingLoggingNestedImpl();
    }

    @Override
    public EntityTopicOperatorSpecFluent.InlineLoggingLoggingNested<A> withNewInlineLoggingLoggingLike(InlineLogging item) {
        return new InlineLoggingLoggingNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityTopicOperatorSpecFluentImpl that = (EntityTopicOperatorSpecFluentImpl)o;
        if (this.watchedNamespace != null ? !this.watchedNamespace.equals(that.watchedNamespace) : that.watchedNamespace != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.reconciliationIntervalSeconds != that.reconciliationIntervalSeconds) {
            return false;
        }
        if (this.zookeeperSessionTimeoutSeconds != that.zookeeperSessionTimeoutSeconds) {
            return false;
        }
        if (this.topicMetadataMaxAttempts != that.topicMetadataMaxAttempts) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.logging != null ? !this.logging.equals(that.logging) : that.logging != null);
    }

    public class InlineLoggingLoggingNestedImpl<N>
    extends InlineLoggingFluentImpl<EntityTopicOperatorSpecFluent.InlineLoggingLoggingNested<N>>
    implements EntityTopicOperatorSpecFluent.InlineLoggingLoggingNested<N>,
    Nested<N> {
        private final InlineLoggingBuilder builder;

        InlineLoggingLoggingNestedImpl(InlineLogging item) {
            this.builder = new InlineLoggingBuilder(this, item);
        }

        InlineLoggingLoggingNestedImpl() {
            this.builder = new InlineLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withInlineLoggingLogging(this.builder.build());
        }

        @Override
        public N endInlineLoggingLogging() {
            return this.and();
        }
    }

    public class ExternalLoggingLoggingNestedImpl<N>
    extends ExternalLoggingFluentImpl<EntityTopicOperatorSpecFluent.ExternalLoggingLoggingNested<N>>
    implements EntityTopicOperatorSpecFluent.ExternalLoggingLoggingNested<N>,
    Nested<N> {
        private final ExternalLoggingBuilder builder;

        ExternalLoggingLoggingNestedImpl(ExternalLogging item) {
            this.builder = new ExternalLoggingBuilder(this, item);
        }

        ExternalLoggingLoggingNestedImpl() {
            this.builder = new ExternalLoggingBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withExternalLoggingLogging(this.builder.build());
        }

        @Override
        public N endExternalLoggingLogging() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourcesFluentImpl<EntityTopicOperatorSpecFluent.ResourcesNested<N>>
    implements EntityTopicOperatorSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourcesBuilder builder;

        ResourcesNestedImpl(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourcesBuilder(this);
        }

        @Override
        public N and() {
            return (N)EntityTopicOperatorSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

