/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimple;
import io.strimzi.api.kafka.model.KafkaAuthorizationSimpleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KafkaAuthorizationSimpleFluentImpl<A extends KafkaAuthorizationSimpleFluent<A>>
extends BaseFluent<A>
implements KafkaAuthorizationSimpleFluent<A> {
    private List<String> superUsers;

    public KafkaAuthorizationSimpleFluentImpl() {
    }

    public KafkaAuthorizationSimpleFluentImpl(KafkaAuthorizationSimple instance) {
        this.withSuperUsers(instance.getSuperUsers());
    }

    @Override
    public A addToSuperUsers(int index, String item) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        }
        this.superUsers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSuperUsers(int index, String item) {
        this.superUsers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSuperUsers(String ... items) {
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSuperUsers(Collection<String> items) {
        for (String item : items) {
            this.superUsers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSuperUsers(String ... items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSuperUsers(Collection<String> items) {
        for (String item : items) {
            if (this.superUsers == null) continue;
            this.superUsers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSuperUsers() {
        return this.superUsers;
    }

    @Override
    public String getSuperUser(int index) {
        return this.superUsers.get(index);
    }

    @Override
    public String getFirstSuperUser() {
        return this.superUsers.get(0);
    }

    @Override
    public String getLastSuperUser() {
        return this.superUsers.get(this.superUsers.size() - 1);
    }

    @Override
    public String getMatchingSuperUser(Predicate<String> predicate) {
        for (String item : this.superUsers) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withSuperUsers(List<String> superUsers) {
        if (this.superUsers == null) {
            this.superUsers = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.superUsers);
            this.superUsers.clear();
        }
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSuperUsers(String ... superUsers) {
        this.superUsers.clear();
        if (superUsers != null) {
            for (String item : superUsers) {
                this.addToSuperUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSuperUsers() {
        return this.superUsers != null && !this.superUsers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaAuthorizationSimpleFluentImpl that = (KafkaAuthorizationSimpleFluentImpl)o;
        return !(this.superUsers != null ? !this.superUsers.equals(that.superUsers) : that.superUsers != null);
    }
}

