/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Toleration;
import io.strimzi.api.kafka.model.InlineLogging;
import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.api.kafka.model.KafkaConnectAuthentication;
import io.strimzi.api.kafka.model.KafkaConnectTls;
import io.strimzi.api.kafka.model.Logging;
import io.strimzi.api.kafka.model.Probe;
import io.strimzi.api.kafka.model.Resources;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.vertx.core.cli.annotations.DefaultValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "image", "livenessProbe", "readinessProbe", "jvmOptions", "affinity", "tolerations", "logging", "metrics"})
public class KafkaConnectSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_IMAGE = System.getenv().getOrDefault("STRIMZI_DEFAULT_KAFKA_CONNECT_IMAGE", "strimzi/kafka-connect:latest");
    public static final String FORBIDDEN_PREFIXES = "ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers";
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private Logging logging;
    private int replicas;
    private String image;
    private Resources resources;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private JvmOptions jvmOptions;
    private Map<String, Object> metrics = new HashMap<String, Object>(0);
    private Affinity affinity;
    private List<Toleration> tolerations;
    private String bootstrapServers;
    private KafkaConnectTls tls;
    private KafkaConnectAuthentication authentication;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="The number of pods in the Kafka Connect group.")
    @DefaultValue(value="3")
    public int getReplicas() {
        return this.replicas;
    }

    @Description(value="The Kafka Connect configuration. Properties with the following prefixes cannot be set: ssl., sasl., security., listeners, plugin.path, rest., bootstrap.servers")
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Logging configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Logging getLogging() {
        return this.logging == null ? new InlineLogging() : this.logging;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    @Description(value="The docker image for the pods.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="Resource constraints (limits and requests).")
    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="Pod liveness checking.")
    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @Description(value="Pod readiness checking.")
    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Description(value="JVM Options for pods")
    public JvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public void setJvmOptions(JvmOptions jvmOptions) {
        this.jvmOptions = jvmOptions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Description(value="The Prometheus JMX Exporter configuration. See https://github.com/prometheus/jmx_exporter for details of the structure of this configuration.")
    public Map<String, Object> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Object> metrics) {
        this.metrics = metrics;
    }

    @Description(value="Pod affinity rules.")
    @KubeLink(group="core", version="v1", kind="affinity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @Description(value="Pod's tolerations.")
    @KubeLink(group="core", version="v1", kind="tolerations")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @Description(value="Bootstrap servers to connect to. This should be given as a comma separated list of _<hostname>_:\u200d_<port>_ pairs.")
    @JsonProperty(required=true)
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Description(value="TLS configuration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaConnectTls getTls() {
        return this.tls;
    }

    public void setTls(KafkaConnectTls tls) {
        this.tls = tls;
    }

    @Description(value="Authentication configuration for Kafka Connect")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public KafkaConnectAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(KafkaConnectAuthentication authentication) {
        this.authentication = authentication;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

