/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.strimzi.api.kafka.model.EntityOperatorSpec;
import io.strimzi.api.kafka.model.KafkaClusterSpec;
import io.strimzi.api.kafka.model.TopicOperatorSpec;
import io.strimzi.api.kafka.model.ZookeeperClusterSpec;
import io.strimzi.crdgenerator.annotations.Description;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kafka", "zookeeper", "topicOperator"})
public class KafkaSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private KafkaClusterSpec kafka;
    private ZookeeperClusterSpec zookeeper;
    private TopicOperatorSpec topicOperator;
    private EntityOperatorSpec entityOperator;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Configuration of the Kafka cluster")
    @JsonProperty(required=true)
    public KafkaClusterSpec getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaClusterSpec kafka) {
        this.kafka = kafka;
    }

    @Description(value="Configuration of the Zookeeper cluster")
    @JsonProperty(required=true)
    public ZookeeperClusterSpec getZookeeper() {
        return this.zookeeper;
    }

    public void setZookeeper(ZookeeperClusterSpec zookeeper) {
        this.zookeeper = zookeeper;
    }

    @Deprecated
    @Description(value="Configuration of the Topic Operator")
    public TopicOperatorSpec getTopicOperator() {
        return this.topicOperator;
    }

    @Deprecated
    public void setTopicOperator(TopicOperatorSpec topicOperator) {
        this.topicOperator = topicOperator;
    }

    @Description(value="Configuration of the Entity Operator")
    public EntityOperatorSpec getEntityOperator() {
        return this.entityOperator;
    }

    public void setEntityOperator(EntityOperatorSpec entityOperator) {
        this.entityOperator = entityOperator;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        YAMLMapper mapper = new YAMLMapper();
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

