/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.KafkaTopicSpec;
import io.strimzi.api.kafka.model.KafkaTopicSpecFluent;
import io.strimzi.api.kafka.model.KafkaTopicSpecFluentImpl;

public class KafkaTopicSpecBuilder
extends KafkaTopicSpecFluentImpl<KafkaTopicSpecBuilder>
implements VisitableBuilder<KafkaTopicSpec, KafkaTopicSpecBuilder> {
    KafkaTopicSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaTopicSpecBuilder() {
        this(true);
    }

    public KafkaTopicSpecBuilder(Boolean validationEnabled) {
        this(new KafkaTopicSpec(), validationEnabled);
    }

    public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KafkaTopicSpec(), validationEnabled);
    }

    public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent, KafkaTopicSpec instance) {
        this(fluent, instance, true);
    }

    public KafkaTopicSpecBuilder(KafkaTopicSpecFluent<?> fluent, KafkaTopicSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTopicName(instance.getTopicName());
        fluent.withPartitions(instance.getPartitions());
        fluent.withReplicas(instance.getReplicas());
        fluent.withConfig(instance.getConfig());
        this.validationEnabled = validationEnabled;
    }

    public KafkaTopicSpecBuilder(KafkaTopicSpec instance) {
        this(instance, (Boolean)true);
    }

    public KafkaTopicSpecBuilder(KafkaTopicSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTopicName(instance.getTopicName());
        this.withPartitions(instance.getPartitions());
        this.withReplicas(instance.getReplicas());
        this.withConfig(instance.getConfig());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KafkaTopicSpec build() {
        KafkaTopicSpec buildable = new KafkaTopicSpec();
        buildable.setTopicName(this.fluent.getTopicName());
        buildable.setPartitions(this.fluent.getPartitions());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setConfig(this.fluent.getConfig());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaTopicSpecBuilder that = (KafkaTopicSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

