/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

public class Quantities {
    private Quantities() {
    }

    public static long parseMemory(String memory) {
        boolean seenE = false;
        long factor = 1L;
        int end = memory.length();
        for (int i = 0; i < memory.length(); ++i) {
            char ch = memory.charAt(i);
            if (ch == 'e') {
                seenE = true;
                continue;
            }
            if (ch >= '0' && '9' >= ch) continue;
            end = i;
            factor = Quantities.memoryFactor(memory.substring(i));
            break;
        }
        long result = seenE ? (long)Double.parseDouble(memory) : Long.parseLong(memory.substring(0, end)) * factor;
        return result;
    }

    private static long memoryFactor(String suffix) {
        long factor;
        switch (suffix) {
            case "E": {
                factor = 1000000000000000L;
                break;
            }
            case "T": {
                factor = 1000000000000L;
                break;
            }
            case "G": {
                factor = 1000000000L;
                break;
            }
            case "M": {
                factor = 1000000L;
                break;
            }
            case "K": {
                factor = 1000L;
                break;
            }
            case "Ei": {
                factor = 0x4000000000000L;
                break;
            }
            case "Ti": {
                factor = 0x10000000000L;
                break;
            }
            case "Gi": {
                factor = 0x40000000L;
                break;
            }
            case "Mi": {
                factor = 0x100000L;
                break;
            }
            case "Ki": {
                factor = 1024L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid memory suffix: " + suffix);
            }
        }
        return factor;
    }

    public static String formatMemory(long bytes) {
        if (bytes == 0L) {
            return "0";
        }
        long x = bytes;
        int i = -1;
        while (x % 1000L == 0L && i < 4) {
            ++i;
            x /= 1000L;
        }
        if (i >= 0) {
            return x + (new String[]{"K", "M", "G", "T", "E"})[i];
        }
        x = bytes;
        i = -1;
        while (x % 1024L == 0L && i < 4) {
            ++i;
            x /= 1024L;
        }
        if (i >= 0) {
            return x + (new String[]{"Ki", "Mi", "Gi", "Ti", "Ei"})[i];
        }
        return Long.toString(bytes);
    }

    public static String normalizeMemory(String memory) {
        return Quantities.formatMemory(Quantities.parseMemory(memory));
    }

    public static int parseCpuAsMilliCpus(String cpu) {
        int suffixIndex = cpu.length();
        int factor = 1000;
        for (int i = 0; i < cpu.length(); ++i) {
            char ch = cpu.charAt(i);
            if (ch >= '0' && '9' >= ch) continue;
            suffixIndex = i;
            if ("m".equals(cpu.substring(i))) {
                factor = 1;
                break;
            }
            if (cpu.substring(i).startsWith(".")) {
                return (int)(Double.parseDouble(cpu) * 1000.0);
            }
            throw new IllegalArgumentException();
        }
        return factor * Integer.parseInt(cpu.substring(0, suffixIndex));
    }

    public static String formatMilliCpu(int milliCpu) {
        if (milliCpu % 1000 == 0) {
            return Long.toString((long)milliCpu / 1000L);
        }
        return Long.toString(milliCpu) + "m";
    }

    public static String normalizeCpu(String milliCpu) {
        return Quantities.formatMilliCpu(Quantities.parseCpuAsMilliCpus(milliCpu));
    }
}

