/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.strimzi.api.kafka.model.EphemeralStorage;
import io.strimzi.api.kafka.model.PersistentClaimStorage;
import io.strimzi.crdgenerator.annotations.Description;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EphemeralStorage.class, name="ephemeral"), @JsonSubTypes.Type(value=PersistentClaimStorage.class, name="persistent-claim")})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Storage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_EPHEMERAL = "ephemeral";
    public static final String TYPE_PERSISTENT_CLAIM = "persistent-claim";
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Storage type, must be either 'ephemeral' or 'persistent-claim'.")
    @JsonIgnore
    public abstract String getType();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static boolean deleteClaim(Storage storage) {
        return storage instanceof PersistentClaimStorage && ((PersistentClaimStorage)storage).isDeleteClaim();
    }

    public static String storageClass(Storage storage) {
        return storage instanceof PersistentClaimStorage ? ((PersistentClaimStorage)storage).getStorageClass() : null;
    }
}

