/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.Http1xServerHandler;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import io.vertx.core.http.impl.HttpServerResponseImpl;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxNetHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;

public class Http1xServerConnection
extends Http1xConnectionBase
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private static final Handler<HttpServerRequest> NULL_REQUEST_HANDLER = req -> {};
    private static final int CHANNEL_PAUSE_QUEUE_SIZE = 5;
    private final Deque<Object> pending = new ArrayDeque<Object>(8);
    private final String serverOrigin;
    private final SSLHelper sslHelper;
    final HttpServerOptions options;
    private WebSocketServerHandshaker handshaker;
    private final HttpServerMetrics metrics;
    private boolean requestFailed;
    private Object requestMetric;
    private Handler<HttpServerRequest> requestHandler = NULL_REQUEST_HANDLER;
    private Handler<ServerWebSocket> wsHandler;
    private HttpServerRequestImpl currentRequest;
    private HttpServerResponseImpl pendingResponse;
    private ServerWebSocketImpl ws;
    private boolean channelPaused;
    private boolean paused;
    private boolean sentCheck;
    private long bytesRead;
    private long bytesWritten;
    private boolean queueing;

    public Http1xServerConnection(VertxInternal vertx, SSLHelper sslHelper, HttpServerOptions options, ChannelHandlerContext channel, ContextImpl context, String serverOrigin, HttpServerMetrics metrics) {
        super(vertx, channel, context);
        this.serverOrigin = serverOrigin;
        this.options = options;
        this.sslHelper = sslHelper;
        this.metrics = metrics;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    synchronized void pause() {
        if (!this.paused) {
            this.paused = true;
            this.queueing = true;
        }
    }

    synchronized void resume() {
        if (this.paused) {
            this.paused = false;
            this.checkNextTick();
        }
    }

    synchronized void handleMessage(Object msg) {
        if (this.queueing) {
            this.enqueue(msg);
        } else if (this.processMessage(msg)) {
            this.checkNextTick();
        } else {
            this.enqueue(msg);
        }
    }

    private void enqueue(Object msg) {
        this.queueing = true;
        this.pending.add(msg);
        if (this.pending.size() == 5) {
            super.doPause();
            this.channelPaused = true;
        }
    }

    synchronized void responseComplete() {
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            this.reportBytesWritten(this.bytesWritten);
            this.bytesWritten = 0L;
            if (this.requestFailed) {
                this.metrics.requestReset(this.requestMetric);
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(this.requestMetric, this.pendingResponse);
            }
        }
        this.pendingResponse = null;
        this.checkNextTick();
    }

    synchronized void requestHandler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
    }

    synchronized void wsHandler(WebSocketServerHandshaker handshaker, Handler<ServerWebSocket> handler) {
        this.handshaker = handshaker;
        this.wsHandler = handler;
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    @Override
    public void writeToChannel(Object msg, ChannelPromise promise) {
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            long bytes = this.getBytes(msg);
            if (bytes == -1L) {
                log.warn("Metrics could not be updated to include bytes written because of unknown object " + msg.getClass() + " being written.");
            } else {
                this.bytesWritten += bytes;
            }
        }
        super.writeToChannel(msg, promise);
    }

    ServerWebSocket upgrade(HttpServerRequest request, HttpRequest nettyReq) {
        if (this.ws != null) {
            return this.ws;
        }
        Http1xServerHandler serverHandler = (Http1xServerHandler)this.chctx.pipeline().get("handler");
        this.handshaker = serverHandler.createHandshaker(this, this.chctx.channel(), nettyReq);
        if (this.handshaker == null) {
            throw new IllegalStateException("Can't upgrade this request");
        }
        this.ws = new ServerWebSocketImpl(this.vertx, request.uri(), request.path(), request.query(), request.headers(), this, this.handshaker.version() != WebSocketVersion.V00, null, this.options.getMaxWebsocketFrameSize(), this.options.getMaxWebsocketMessageSize());
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            this.ws.setMetric(this.metrics.upgrade(this.requestMetric, this.ws));
        }
        try {
            this.handshaker.handshake(this.chctx.channel(), nettyReq);
        }
        catch (WebSocketHandshakeException e) {
            this.handleException(e);
        }
        catch (Exception e) {
            log.error((Object)"Failed to generate shake response", e);
        }
        HttpChunkContentCompressor handler = this.chctx.pipeline().get(HttpChunkContentCompressor.class);
        if (handler != null) {
            this.chctx.pipeline().remove(handler);
        }
        return this.ws;
    }

    NetSocket createNetSocket() {
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.sslHelper, this.metrics);
        socket.metric(this.metric());
        HashMap<Channel, NetSocketImpl> connectionMap = new HashMap<Channel, NetSocketImpl>(1);
        connectionMap.put(this.chctx.channel(), socket);
        this.endReadAndFlush();
        ChannelPipeline pipeline = this.chctx.pipeline();
        HttpChunkContentCompressor compressor = pipeline.get(HttpChunkContentCompressor.class);
        if (compressor != null) {
            pipeline.remove(compressor);
        }
        pipeline.remove("httpDecoder");
        if (pipeline.get("chunkedWriter") != null) {
            pipeline.remove("chunkedWriter");
        }
        this.chctx.pipeline().replace("handler", "handler", new VertxNetHandler(socket){

            @Override
            public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release(msg);
                    return;
                }
                super.channelRead(chctx, msg);
            }

            @Override
            protected void handleMessage(NetSocketImpl connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
                ByteBuf buf = (ByteBuf)msg;
                connection.handleMessageReceived(buf);
            }
        }.removeHandler(sock -> {
            NetSocketImpl cfr_ignored_0 = (NetSocketImpl)connectionMap.remove(this.chctx.channel());
        }));
        this.chctx.pipeline().remove("httpEncoder");
        return socket;
    }

    private void handleChunk(Buffer chunk) {
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            this.bytesRead += (long)chunk.length();
        }
        this.currentRequest.handleData(chunk);
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.pendingResponse != null) {
                this.pendingResponse.handleDrained();
            } else if (this.ws != null) {
                this.ws.writable();
            }
        }
    }

    @Override
    public void close() {
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.chctx.channel(), new CloseWebSocketFrame(true, 0, 1000, null));
        }
    }

    @Override
    public void closeWithPayload(ByteBuf byteBuf) {
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.chctx.channel(), new CloseWebSocketFrame(true, 0, byteBuf));
        }
    }

    synchronized void handleWebsocketConnect(ServerWebSocketImpl ws) {
        if (this.wsHandler != null) {
            this.wsHandler.handle(ws);
            this.ws = ws;
        }
    }

    void write100Continue() {
        this.chctx.writeAndFlush(new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    @Override
    protected synchronized void handleClosed() {
        if (Metrics.METRICS_ENABLED && this.metrics != null && this.ws != null) {
            this.metrics.disconnected(this.ws.getMetric());
            this.ws.setMetric(null);
        }
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        if (this.currentRequest != null) {
            this.currentRequest.handleException(new VertxException("Connection was closed"));
        }
        if (this.pendingResponse != null) {
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.metrics.requestReset(this.requestMetric);
            }
            this.pendingResponse.handleClosed();
        }
    }

    @Override
    public ContextImpl getContext() {
        return super.getContext();
    }

    @Override
    protected synchronized void handleException(Throwable t) {
        super.handleException(t);
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            this.requestFailed = true;
        }
        if (this.currentRequest != null) {
            this.currentRequest.handleException(t);
        }
        if (this.pendingResponse != null) {
            this.pendingResponse.handleException(t);
        }
        if (this.ws != null) {
            this.ws.handleException(t);
        }
    }

    @Override
    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        super.addFuture(completionHandler, future);
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    @Override
    protected ChannelFuture sendFile(RandomAccessFile file, long offset, long length) throws IOException {
        return super.sendFile(file, offset, length);
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        Throwable cause = result.cause();
        if (cause instanceof TooLongFrameException) {
            String causeMsg = cause.getMessage();
            io.netty.handler.codec.http.HttpVersion version = obj instanceof HttpRequest ? ((HttpRequest)obj).protocolVersion() : (this.currentRequest != null ? (this.currentRequest.version() == HttpVersion.HTTP_1_0 ? io.netty.handler.codec.http.HttpVersion.HTTP_1_0 : io.netty.handler.codec.http.HttpVersion.HTTP_1_1) : io.netty.handler.codec.http.HttpVersion.HTTP_1_1);
            HttpResponseStatus status = causeMsg.startsWith("An HTTP line is larger than") ? HttpResponseStatus.REQUEST_URI_TOO_LONG : HttpResponseStatus.BAD_REQUEST;
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(version, status);
            ChannelPromise fut = this.chctx.newPromise();
            this.writeToChannel(resp, fut);
            fut.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)res -> {
                if (res.isSuccess()) {
                    this.chctx.pipeline().fireExceptionCaught(result.cause());
                }
            }));
        } else {
            this.chctx.pipeline().fireExceptionCaught(result.cause());
        }
    }

    private boolean processMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            HttpServerRequestImpl req;
            if (this.pendingResponse != null) {
                return false;
            }
            HttpRequest request = (HttpRequest)msg;
            if (request.decoderResult().isFailure()) {
                this.handleError(request);
                return false;
            }
            if (this.options.isHandle100ContinueAutomatically() && HttpUtil.is100ContinueExpected(request)) {
                this.write100Continue();
            }
            HttpServerResponseImpl resp = new HttpServerResponseImpl(this.vertx, this, request);
            this.currentRequest = req = new HttpServerRequestImpl(this, request, resp);
            this.pendingResponse = resp;
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.requestMetric = this.metrics.requestBegin(this.metric(), req);
            }
            this.requestHandler.handle(req);
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.handleLastHttpContent();
        } else if (msg instanceof HttpContent) {
            this.handleContent(msg);
        } else {
            this.handleOther(msg);
        }
        return true;
    }

    private void handleContent(Object msg) {
        HttpContent content = (HttpContent)msg;
        if (content.decoderResult().isFailure()) {
            this.handleError(content);
            return;
        }
        ByteBuf chunk = content.content();
        if (chunk.isReadable()) {
            Buffer buff = Buffer.buffer(chunk);
            this.handleChunk(buff);
        }
        if (content instanceof LastHttpContent) {
            this.handleLastHttpContent();
        }
    }

    private void handleLastHttpContent() {
        this.currentRequest.handleEnd();
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesRead(this.bytesRead);
            this.bytesRead = 0L;
        }
        this.currentRequest = null;
    }

    private void handleOther(Object msg) {
        if (msg instanceof WebSocketFrameInternal) {
            WebSocketFrameInternal frame = (WebSocketFrameInternal)msg;
            if (this.ws != null) {
                this.ws.handleFrame(frame);
            }
        }
    }

    private void checkNextTick() {
        if (!this.paused && !this.sentCheck) {
            this.sentCheck = true;
            this.vertx.runOnContext(v -> {
                Http1xServerConnection http1xServerConnection = this;
                synchronized (http1xServerConnection) {
                    this.sentCheck = false;
                    if (!this.paused) {
                        Object msg = this.pending.poll();
                        if (msg != null) {
                            if (this.processMessage(msg)) {
                                this.checkNextTick();
                            } else {
                                this.pending.addFirst(msg);
                            }
                        }
                        if (this.pending.isEmpty()) {
                            this.queueing = false;
                            if (this.channelPaused) {
                                this.channelPaused = false;
                                Http1xServerConnection.super.doResume();
                            }
                        } else {
                            this.queueing = true;
                            this.checkNextTick();
                        }
                    }
                }
            });
        }
    }

    private long getBytes(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrameInternal)obj).length();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return -1L;
    }
}

