/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.MultiMap;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.impl.VertxInternal;
import java.util.function.Supplier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class ServerWebSocketImpl
extends WebSocketImplBase<ServerWebSocket>
implements ServerWebSocket {
    private final String uri;
    private final String path;
    private final String query;
    private final Supplier<String> connect;
    private final MultiMap headers;
    private boolean connected;
    private boolean rejected;
    private HttpResponseStatus rejectedStatus;

    public ServerWebSocketImpl(VertxInternal vertx, String uri, String path, String query, MultiMap headers, Http1xConnectionBase conn, boolean supportsContinuation, Supplier<String> connectRunnable, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        super(vertx, conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize);
        this.uri = uri;
        this.path = path;
        this.query = query;
        this.headers = headers;
        this.connect = connectRunnable;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.checkAccept()) {
                throw new IllegalStateException("Websocket already rejected");
            }
        }
    }

    @Override
    public void reject() {
        this.reject(HttpResponseStatus.BAD_GATEWAY);
    }

    @Override
    public void reject(int status) {
        this.reject(HttpResponseStatus.valueOf(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reject(HttpResponseStatus status) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (this.connect == null) {
                throw new IllegalStateException("Cannot reject websocket on the client side");
            }
            if (this.connected) {
                throw new IllegalStateException("Cannot reject websocket, it has already been written to");
            }
            this.rejected = true;
            this.rejectedStatus = status;
        }
    }

    @Override
    public SSLSession sslSession() {
        return this.conn.sslSession();
    }

    @Override
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.conn.peerCertificateChain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            this.checkClosed();
            if (this.checkAccept()) {
                throw new IllegalStateException("Cannot close websocket, it has been rejected");
            }
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerWebSocket writeFrame(WebSocketFrame frame) {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.checkAccept()) {
                throw new IllegalStateException("Cannot write to websocket, it has been rejected");
            }
            return (ServerWebSocket)super.writeFrame(frame);
        }
    }

    private boolean checkAccept() {
        if (this.connect != null) {
            if (this.isRejected()) {
                return true;
            }
            if (!this.connected && !this.closed) {
                this.connect();
            }
        }
        return false;
    }

    private void connect() {
        this.subProtocol(this.connect.get());
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectNow() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (!this.connected && !this.isRejected()) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRejected() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.rejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HttpResponseStatus getRejectedStatus() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            return this.rejectedStatus;
        }
    }
}

