/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class BlockedThreadChecker {
    private static final Logger log = LoggerFactory.getLogger(BlockedThreadChecker.class);
    private static final Object O = new Object();
    private final Map<VertxThread, Object> threads = new WeakHashMap<VertxThread, Object>();
    private final Timer timer = new Timer("vertx-blocked-thread-checker", true);

    BlockedThreadChecker(long interval, final long warningExceptionTime) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BlockedThreadChecker blockedThreadChecker = BlockedThreadChecker.this;
                synchronized (blockedThreadChecker) {
                    long now = System.nanoTime();
                    for (VertxThread thread : BlockedThreadChecker.this.threads.keySet()) {
                        long execStart = thread.startTime();
                        long dur = now - execStart;
                        long timeLimit = thread.getMaxExecTime();
                        if (execStart == 0L || dur <= timeLimit) continue;
                        String message = "Thread " + thread + " has been blocked for " + dur / 1000000L + " ms, time limit is " + timeLimit / 1000000L;
                        if (dur <= warningExceptionTime) {
                            log.warn(message);
                            continue;
                        }
                        VertxException stackTrace = new VertxException("Thread blocked");
                        stackTrace.setStackTrace(thread.getStackTrace());
                        log.warn((Object)message, stackTrace);
                    }
                }
            }
        }, interval, interval);
    }

    public synchronized void registerThread(VertxThread thread) {
        this.threads.put(thread, O);
    }

    public void close() {
        this.timer.cancel();
    }
}

