/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Starter;
import io.vertx.core.impl.Action;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.ContextTask;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.launcher.VertxCommandLauncher;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public abstract class ContextImpl
implements ContextInternal {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private static final String THREAD_CHECKS_PROP_NAME = "vertx.threadChecks";
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    private static final String DISABLE_TCCL_PROP_NAME = "vertx.disableTCCL";
    private static final boolean THREAD_CHECKS = Boolean.getBoolean("vertx.threadChecks");
    private static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    private static final boolean DISABLE_TCCL = Boolean.getBoolean("vertx.disableTCCL");
    protected final VertxInternal owner;
    protected final String deploymentID;
    protected final JsonObject config;
    private Deployment deployment;
    private CloseHooks closeHooks;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    protected VertxThread contextThread;
    private ConcurrentMap<Object, Object> contextData;
    private volatile Handler<Throwable> exceptionHandler;
    protected final WorkerPool workerPool;
    protected final WorkerPool internalBlockingPool;
    final TaskQueue orderedTasks;
    protected final TaskQueue internalOrderedTasks;

    private static EventLoop getEventLoop(VertxInternal vertx) {
        EventLoopGroup group = vertx.getEventLoopGroup();
        if (group != null) {
            return group.next();
        }
        return null;
    }

    protected ContextImpl(VertxInternal vertx, WorkerPool internalBlockingPool, WorkerPool workerPool, String deploymentID, JsonObject config, ClassLoader tccl) {
        this(vertx, ContextImpl.getEventLoop(vertx), internalBlockingPool, workerPool, deploymentID, config, tccl);
    }

    protected ContextImpl(VertxInternal vertx, EventLoop eventLoop, WorkerPool internalBlockingPool, WorkerPool workerPool, String deploymentID, JsonObject config, ClassLoader tccl) {
        if (DISABLE_TCCL && !tccl.getClass().getName().equals("sun.misc.Launcher$AppClassLoader")) {
            log.warn("You have disabled TCCL checks but you have a custom TCCL to set.");
        }
        this.deploymentID = deploymentID;
        this.config = config;
        this.eventLoop = eventLoop;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.internalBlockingPool = internalBlockingPool;
        this.orderedTasks = new TaskQueue();
        this.internalOrderedTasks = new TaskQueue();
        this.closeHooks = new CloseHooks(log);
    }

    public static void setContext(ContextImpl context) {
        Thread current = Thread.currentThread();
        if (!(current instanceof VertxThread)) {
            throw new IllegalStateException("Attempt to setContext on non Vert.x thread " + Thread.currentThread());
        }
        ContextImpl.setContext((VertxThread)current, context);
    }

    private static void setContext(VertxThread thread, ContextImpl context) {
        thread.setContext(context);
        if (!DISABLE_TCCL) {
            if (context != null) {
                context.setTCCL();
            } else {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        this.closeHooks.add(hook);
    }

    @Override
    public void removeCloseHook(Closeable hook) {
        this.closeHooks.remove(hook);
    }

    public void runCloseHooks(Handler<AsyncResult<Void>> completionHandler) {
        this.closeHooks.run(completionHandler);
        VertxThreadFactory.unsetContext(this);
    }

    protected abstract void executeAsync(Handler<Void> var1);

    @Override
    public abstract boolean isEventLoopContext();

    @Override
    public abstract boolean isMultiThreadedWorkerContext();

    @Override
    public <T> T get(String key) {
        return (T)this.contextData().get(key);
    }

    @Override
    public void put(String key, Object value) {
        this.contextData().put(key, value);
    }

    @Override
    public boolean remove(String key) {
        return this.contextData().remove(key) != null;
    }

    @Override
    public boolean isWorkerContext() {
        return !this.isEventLoopContext();
    }

    public static boolean isOnWorkerThread() {
        return ContextImpl.isOnVertxThread(true);
    }

    public static boolean isOnEventLoopThread() {
        return ContextImpl.isOnVertxThread(false);
    }

    public static boolean isOnVertxThread() {
        Thread t = Thread.currentThread();
        return t instanceof VertxThread;
    }

    private static boolean isOnVertxThread(boolean worker) {
        Thread t = Thread.currentThread();
        if (t instanceof VertxThread) {
            VertxThread vt = (VertxThread)t;
            return vt.isWorker() == worker;
        }
        return false;
    }

    @Override
    public void executeFromIO(ContextTask task) {
        if (THREAD_CHECKS) {
            this.checkCorrectThread();
        }
        this.wrapTask(task, null, true, null).run();
    }

    protected abstract void checkCorrectThread();

    @Override
    public void runOnContext(Handler<Void> task) {
        try {
            this.executeAsync(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public String deploymentID() {
        return this.deploymentID;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public List<String> processArgs() {
        List<String> processArgument = VertxCommandLauncher.getProcessArguments();
        return processArgument != null ? processArgument : Starter.PROCESS_ARGS;
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop;
    }

    @Override
    public VertxInternal owner() {
        return this.owner;
    }

    public <T> void executeBlocking(Action<T> action, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(action, null, resultHandler, this.internalBlockingPool.executor(), this.internalOrderedTasks, this.internalBlockingPool.metrics());
    }

    @Override
    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(null, blockingCodeHandler, resultHandler, this.workerPool.executor(), ordered ? this.orderedTasks : null, this.workerPool.metrics());
    }

    @Override
    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, TaskQueue queue, Handler<AsyncResult<T>> resultHandler) {
        this.executeBlocking(null, blockingCodeHandler, resultHandler, this.workerPool.executor(), queue, this.workerPool.metrics());
    }

    <T> void executeBlocking(Action<T> action, Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> resultHandler, Executor exec, TaskQueue queue, PoolMetrics metrics) {
        Object queueMetric = metrics != null ? (Object)metrics.submitted() : null;
        try {
            Runnable command = () -> {
                VertxThread current = (VertxThread)Thread.currentThread();
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                if (!DISABLE_TIMINGS) {
                    current.executeStart();
                }
                Future res = Future.future();
                try {
                    if (blockingCodeHandler != null) {
                        ContextImpl.setContext(this);
                        blockingCodeHandler.handle(res);
                    } else {
                        Object result = action.perform();
                        res.complete(result);
                    }
                }
                catch (Throwable e) {
                    res.fail(e);
                }
                finally {
                    if (!DISABLE_TIMINGS) {
                        current.executeEnd();
                    }
                }
                if (metrics != null) {
                    metrics.end(execMetric, res.succeeded());
                }
                if (resultHandler != null) {
                    this.runOnContext(v -> res.setHandler(resultHandler));
                }
            };
            if (queue != null) {
                queue.execute(command, exec);
            } else {
                exec.execute(command);
            }
        }
        catch (RejectedExecutionException e) {
            if (metrics != null) {
                metrics.rejected(queueMetric);
            }
            throw e;
        }
    }

    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.contextData == null) {
            this.contextData = new ConcurrentHashMap<Object, Object>();
        }
        return this.contextData;
    }

    protected Runnable wrapTask(ContextTask cTask, Handler<Void> hTask, boolean checkThread, PoolMetrics metrics) {
        Object metric = metrics != null ? metrics.submitted() : null;
        return () -> {
            Thread th = Thread.currentThread();
            if (!(th instanceof VertxThread)) {
                throw new IllegalStateException("Uh oh! Event loop context executing with wrong thread! Expected " + this.contextThread + " got " + th);
            }
            VertxThread current = (VertxThread)th;
            if (THREAD_CHECKS && checkThread) {
                if (this.contextThread == null) {
                    this.contextThread = current;
                } else if (this.contextThread != current && !this.contextThread.isWorker()) {
                    throw new IllegalStateException("Uh oh! Event loop context executing with wrong thread! Expected " + this.contextThread + " got " + current);
                }
            }
            if (metrics != null) {
                metrics.begin(metric);
            }
            if (!DISABLE_TIMINGS) {
                current.executeStart();
            }
            try {
                ContextImpl.setContext(current, this);
                if (cTask != null) {
                    cTask.run();
                } else {
                    hTask.handle(null);
                }
                if (metrics != null) {
                    metrics.end(metric, true);
                }
            }
            catch (Throwable t) {
                log.error((Object)"Unhandled exception", t);
                Handler<Throwable> handler = this.exceptionHandler;
                if (handler == null) {
                    handler = this.owner.exceptionHandler();
                }
                if (handler != null) {
                    handler.handle(t);
                }
                if (metrics != null) {
                    metrics.end(metric, false);
                }
            }
            finally {
                if (!DISABLE_TIMINGS) {
                    current.executeEnd();
                }
            }
        };
    }

    private void setTCCL() {
        Thread.currentThread().setContextClassLoader(this.tccl);
    }

    @Override
    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public int getInstanceCount() {
        if (this.deployment == null) {
            return 0;
        }
        if (this.deployment.deploymentOptions() == null) {
            return 1;
        }
        return this.deployment.deploymentOptions().getInstances();
    }
}

