/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.file.impl.WindowsFileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.impl.Action;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.BlockedThreadChecker;
import io.vertx.core.impl.CloseHooks;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.FileResolver;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.MultiThreadedWorkerContext;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.VertxThreadFactory;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.WorkerExecutorImpl;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.resolver.DnsResolverProvider;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetClientImpl;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.transport.Transport;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.SharedDataImpl;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class VertxImpl
implements VertxInternal,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(VertxImpl.class);
    private static final String NETTY_IO_RATIO_PROPERTY_NAME = "vertx.nettyIORatio";
    private static final int NETTY_IO_RATIO = Integer.getInteger("vertx.nettyIORatio", 50);
    private final FileSystem fileSystem = this.getFileSystem();
    private final SharedData sharedData;
    private final VertxMetrics metrics;
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final ClusterManager clusterManager;
    private final DeploymentManager deploymentManager;
    private final FileResolver fileResolver;
    private final Map<ServerID, HttpServerImpl> sharedHttpServers = new HashMap<ServerID, HttpServerImpl>();
    private final Map<ServerID, NetServerImpl> sharedNetServers = new HashMap<ServerID, NetServerImpl>();
    final WorkerPool workerPool;
    final WorkerPool internalBlockingPool;
    private final ThreadFactory eventLoopThreadFactory;
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroup acceptorEventLoopGroup;
    private final BlockedThreadChecker checker;
    private final boolean haEnabled;
    private final AddressResolver addressResolver;
    private final AddressResolverOptions addressResolverOptions;
    private EventBus eventBus;
    private HAManager haManager;
    private boolean closed;
    private volatile Handler<Throwable> exceptionHandler;
    private final Map<String, SharedWorkerPool> namedWorkerPools;
    private final int defaultWorkerPoolSize;
    private final long defaultWorkerMaxExecTime;
    private final CloseHooks closeHooks;
    private final Transport transport;

    VertxImpl() {
        this(new VertxOptions());
    }

    VertxImpl(VertxOptions options) {
        this(options, null);
    }

    VertxImpl(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        Transport nativeTransport;
        if (Vertx.currentContext() != null) {
            log.warn("You're already on a Vert.x context, are you sure you want to create a new Vertx instance?");
        }
        this.transport = options.getPreferNativeTransport() ? ((nativeTransport = Transport.nativeTransport()) != null && nativeTransport.isAvailable() ? nativeTransport : Transport.JDK) : Transport.JDK;
        this.closeHooks = new CloseHooks(log);
        this.checker = new BlockedThreadChecker(options.getBlockedThreadCheckInterval(), options.getWarningExceptionTime());
        this.eventLoopThreadFactory = new VertxThreadFactory("vert.x-eventloop-thread-", this.checker, false, options.getMaxEventLoopExecuteTime());
        this.eventLoopGroup = this.transport.eventLoopGroup(options.getEventLoopPoolSize(), this.eventLoopThreadFactory, NETTY_IO_RATIO);
        VertxThreadFactory acceptorEventLoopThreadFactory = new VertxThreadFactory("vert.x-acceptor-thread-", this.checker, false, options.getMaxEventLoopExecuteTime());
        this.acceptorEventLoopGroup = this.transport.eventLoopGroup(1, acceptorEventLoopThreadFactory, 100);
        this.metrics = this.initialiseMetrics(options);
        ExecutorService workerExec = Executors.newFixedThreadPool(options.getWorkerPoolSize(), new VertxThreadFactory("vert.x-worker-thread-", this.checker, true, options.getMaxWorkerExecuteTime()));
        PoolMetrics<?> workerPoolMetrics = this.metrics != null ? this.metrics.createMetrics(workerExec, "worker", "vert.x-worker-thread", options.getWorkerPoolSize()) : null;
        ExecutorService internalBlockingExec = Executors.newFixedThreadPool(options.getInternalBlockingPoolSize(), new VertxThreadFactory("vert.x-internal-blocking-", this.checker, true, options.getMaxWorkerExecuteTime()));
        PoolMetrics<?> internalBlockingPoolMetrics = this.metrics != null ? this.metrics.createMetrics(internalBlockingExec, "worker", "vert.x-internal-blocking", options.getInternalBlockingPoolSize()) : null;
        this.internalBlockingPool = new WorkerPool(internalBlockingExec, internalBlockingPoolMetrics);
        this.namedWorkerPools = new HashMap<String, SharedWorkerPool>();
        this.workerPool = new WorkerPool(workerExec, workerPoolMetrics);
        this.defaultWorkerPoolSize = options.getWorkerPoolSize();
        this.defaultWorkerMaxExecTime = options.getMaxWorkerExecuteTime();
        this.fileResolver = new FileResolver(this, options.isFileResolverCachingEnabled());
        this.addressResolverOptions = options.getAddressResolverOptions();
        this.addressResolver = new AddressResolver(this, options.getAddressResolverOptions());
        this.deploymentManager = new DeploymentManager(this);
        boolean bl = this.haEnabled = options.isClustered() && options.isHAEnabled();
        if (options.isClustered()) {
            this.clusterManager = this.getClusterManager(options);
            this.clusterManager.setVertx(this);
            this.clusterManager.join(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to join cluster", ar.cause());
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                } else {
                    VertxImpl vertxImpl = this;
                    synchronized (vertxImpl) {
                        this.haManager = new HAManager(this, this.deploymentManager, this.clusterManager, options.getQuorumSize(), options.getHAGroup(), this.haEnabled);
                        this.createAndStartEventBus(options, resultHandler);
                    }
                }
            });
        } else {
            this.clusterManager = null;
            this.createAndStartEventBus(options, resultHandler);
        }
        this.sharedData = new SharedDataImpl(this, this.clusterManager);
    }

    private void createAndStartEventBus(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        this.eventBus = options.isClustered() ? new ClusteredEventBus(this, options, this.clusterManager, this.haManager) : new EventBusImpl(this);
        this.eventBus.start(ar -> {
            if (ar.succeeded()) {
                if (this.metrics != null) {
                    this.metrics.eventBusInitialized(this.eventBus);
                }
                if (resultHandler != null) {
                    resultHandler.handle(Future.succeededFuture(this));
                }
            } else {
                log.error((Object)"Failed to start event bus", ar.cause());
                if (resultHandler != null) {
                    resultHandler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    protected FileSystem getFileSystem() {
        return Utils.isWindows() ? new WindowsFileSystem(this) : new FileSystemImpl(this);
    }

    @Override
    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        return DatagramSocketImpl.create(this, options);
    }

    @Override
    public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    @Override
    public NetServer createNetServer(NetServerOptions options) {
        return new NetServerImpl(this, options);
    }

    @Override
    public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    @Override
    public NetClient createNetClient(NetClientOptions options) {
        return new NetClientImpl(this, options);
    }

    @Override
    public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public boolean isNativeTransportEnabled() {
        return this.transport != Transport.JDK;
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer(HttpServerOptions serverOptions) {
        return new HttpServerImpl(this, serverOptions);
    }

    @Override
    public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    @Override
    public HttpClient createHttpClient(HttpClientOptions options) {
        return new HttpClientImpl(this, options);
    }

    @Override
    public HttpClient createHttpClient() {
        return this.createHttpClient(new HttpClientOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBus eventBus() {
        if (this.eventBus == null) {
            VertxImpl vertxImpl = this;
            synchronized (vertxImpl) {
                return this.eventBus;
            }
        }
        return this.eventBus;
    }

    @Override
    public long setPeriodic(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, true);
    }

    @Override
    public TimeoutStream periodicStream(long delay) {
        return new TimeoutStreamImpl(delay, true);
    }

    @Override
    public long setTimer(long delay, Handler<Long> handler) {
        return this.scheduleTimeout(this.getOrCreateContext(), handler, delay, false);
    }

    @Override
    public TimeoutStream timerStream(long delay) {
        return new TimeoutStreamImpl(delay, false);
    }

    @Override
    public void runOnContext(Handler<Void> task) {
        ContextImpl context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    @Override
    public ExecutorService getWorkerPool() {
        return this.workerPool.executor();
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public EventLoopGroup getAcceptorEventLoopGroup() {
        return this.acceptorEventLoopGroup;
    }

    @Override
    public ContextImpl getOrCreateContext() {
        ContextImpl ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext(null, null, new JsonObject(), Thread.currentThread().getContextClassLoader());
        }
        return ctx;
    }

    @Override
    public Map<ServerID, HttpServerImpl> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    @Override
    public Map<ServerID, NetServerImpl> sharedNetServers() {
        return this.sharedNetServers;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.remove(id);
        if (handler != null) {
            handler.context.removeCloseHook(handler);
            return handler.cancel();
        }
        return false;
    }

    @Override
    public EventLoopContext createEventLoopContext(String deploymentID, WorkerPool workerPool, JsonObject config, ClassLoader tccl) {
        return new EventLoopContext(this, this.internalBlockingPool, workerPool != null ? workerPool : this.workerPool, deploymentID, config, tccl);
    }

    @Override
    public ContextImpl createWorkerContext(boolean multiThreaded, String deploymentID, WorkerPool workerPool, JsonObject config, ClassLoader tccl) {
        if (workerPool == null) {
            workerPool = this.workerPool;
        }
        if (multiThreaded) {
            return new MultiThreadedWorkerContext(this, this.internalBlockingPool, workerPool, deploymentID, config, tccl);
        }
        return new WorkerContext(this, this.internalBlockingPool, workerPool, deploymentID, config, tccl);
    }

    @Override
    public DnsClient createDnsClient(int port, String host) {
        return new DnsClientImpl(this, port, host, 5000L);
    }

    @Override
    public DnsClient createDnsClient() {
        return this.createDnsClient(new DnsClientOptions());
    }

    @Override
    public DnsClient createDnsClient(DnsClientOptions options) {
        String host = options.getHost();
        int port = options.getPort();
        if (host == null || port < 0) {
            DnsResolverProvider provider = new DnsResolverProvider(this, this.addressResolverOptions);
            InetSocketAddress address = provider.nameServerAddresses().get(0);
            host = address.getAddress().getHostAddress();
            port = address.getPort();
        }
        return new DnsClientImpl(this, port, host, options.getQueryTimeout());
    }

    private VertxMetrics initialiseMetrics(VertxOptions options) {
        if (options.getMetricsOptions() != null && options.getMetricsOptions().isEnabled()) {
            VertxMetricsFactory factory = options.getMetricsOptions().getFactory();
            if (factory == null && (factory = ServiceHelper.loadFactoryOrNull(VertxMetricsFactory.class)) == null) {
                log.warn("Metrics has been set to enabled but no VertxMetricsFactory found on classpath");
            }
            if (factory != null) {
                VertxMetrics metrics = factory.metrics(this, options);
                Objects.requireNonNull(metrics, "The metric instance created from " + factory + " cannot be null");
                return metrics;
            }
        }
        return null;
    }

    private ClusterManager getClusterManager(VertxOptions options) {
        if (options.isClustered()) {
            ClusterManager mgr;
            if (options.getClusterManager() != null) {
                return options.getClusterManager();
            }
            String clusterManagerClassName = System.getProperty("vertx.cluster.managerClass");
            if (clusterManagerClassName != null) {
                try {
                    Class<?> clazz = Class.forName(clusterManagerClassName);
                    mgr = (ClusterManager)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to instantiate " + clusterManagerClassName, e);
                }
            } else {
                mgr = ServiceHelper.loadFactoryOrNull(ClusterManager.class);
                if (mgr == null) {
                    throw new IllegalStateException("No ClusterManagerFactory instances found on classpath");
                }
            }
            return mgr;
        }
        return null;
    }

    private long scheduleTimeout(ContextImpl context, Handler<Long> handler, long delay, boolean periodic) {
        if (delay < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, delay, context);
        this.timeouts.put(timerId, task);
        context.addCloseHook(task);
        return timerId;
    }

    public static Context context() {
        Thread current = Thread.currentThread();
        if (current instanceof VertxThread) {
            return ((VertxThread)current).getContext();
        }
        return null;
    }

    @Override
    public ContextImpl getContext() {
        ContextImpl context = (ContextImpl)VertxImpl.context();
        if (context != null && context.owner == this) {
            return context;
        }
        return null;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public void close() {
        this.close(null);
    }

    private void closeClusterManager(Handler<AsyncResult<Void>> completionHandler) {
        if (this.clusterManager != null) {
            this.clusterManager.leave(ar -> {
                if (ar.failed()) {
                    log.error((Object)"Failed to leave cluster", ar.cause());
                }
                if (completionHandler != null) {
                    this.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
                }
            });
        } else if (completionHandler != null) {
            this.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed || this.eventBus == null) {
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
            return;
        }
        this.closed = true;
        this.closeHooks.run(ar -> this.deploymentManager.undeployAll(ar1 -> {
            if (this.haManager() != null) {
                this.haManager().stop();
            }
            this.addressResolver.close((Void ar2) -> this.eventBus.close(ar3 -> this.closeClusterManager(ar4 -> {
                HashSet<HttpServerImpl> httpServers = new HashSet<HttpServerImpl>(this.sharedHttpServers.values());
                HashSet<NetServerImpl> netServers = new HashSet<NetServerImpl>(this.sharedNetServers.values());
                this.sharedHttpServers.clear();
                this.sharedNetServers.clear();
                int serverCount = httpServers.size() + netServers.size();
                AtomicInteger serverCloseCount = new AtomicInteger();
                Handler<AsyncResult<Void>> serverCloseHandler = res -> {
                    if (res.failed()) {
                        log.error((Object)"Failure in shutting down server", res.cause());
                    }
                    if (serverCloseCount.incrementAndGet() == serverCount) {
                        this.deleteCacheDirAndShutdown(completionHandler);
                    }
                };
                for (HttpServer httpServer : httpServers) {
                    httpServer.close(serverCloseHandler);
                }
                for (NetServerImpl netServerImpl : netServers) {
                    netServerImpl.close(serverCloseHandler);
                }
                if (serverCount == 0) {
                    this.deleteCacheDirAndShutdown(completionHandler);
                }
            })));
        }));
    }

    @Override
    public void deployVerticle(Verticle verticle) {
        this.deployVerticle(verticle, new DeploymentOptions(), null);
    }

    @Override
    public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(verticle, new DeploymentOptions(), completionHandler);
    }

    @Override
    public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(name, new DeploymentOptions(), completionHandler);
    }

    @Override
    public void deployVerticle(Verticle verticle, DeploymentOptions options) {
        this.deployVerticle(verticle, options, null);
    }

    @Override
    public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options) {
        this.deployVerticle(() -> {
            try {
                return (Verticle)verticleClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, options);
    }

    @Override
    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        this.deployVerticle(verticleSupplier, options, null);
    }

    @Override
    public void deployVerticle(Verticle verticle, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.getInstances() != 1) {
            throw new IllegalArgumentException("Can't specify > 1 instances for already created verticle");
        }
        this.deployVerticle(() -> verticle, options, completionHandler);
    }

    @Override
    public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(() -> {
            try {
                return (Verticle)verticleClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, options, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        boolean closed;
        VertxImpl vertxImpl = this;
        synchronized (vertxImpl) {
            closed = this.closed;
        }
        if (closed) {
            if (completionHandler != null) {
                completionHandler.handle(Future.failedFuture("Vert.x closed"));
            }
        } else {
            this.deploymentManager.deployVerticle(verticleSupplier, options, completionHandler);
        }
    }

    @Override
    public void deployVerticle(String name) {
        this.deployVerticle(name, new DeploymentOptions(), null);
    }

    @Override
    public void deployVerticle(String name, DeploymentOptions options) {
        this.deployVerticle(name, options, null);
    }

    @Override
    public void deployVerticle(String name, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.isHa() && this.haManager() != null && this.haManager().isEnabled()) {
            this.haManager().deployVerticle(name, options, completionHandler);
        } else {
            this.deploymentManager.deployVerticle(name, options, completionHandler);
        }
    }

    @Override
    public String getNodeID() {
        return this.clusterManager.getNodeID();
    }

    @Override
    public void undeploy(String deploymentID) {
        this.undeploy(deploymentID, res -> {});
    }

    @Override
    public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        if (this.haManager() != null && this.haManager().isEnabled()) {
            this.haManager().removeFromHA(deploymentID);
        }
        this.deploymentManager.undeployVerticle(deploymentID, completionHandler);
    }

    @Override
    public Set<String> deploymentIDs() {
        return this.deploymentManager.deployments();
    }

    @Override
    public void registerVerticleFactory(VerticleFactory factory) {
        this.deploymentManager.registerVerticleFactory(factory);
    }

    @Override
    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.deploymentManager.unregisterVerticleFactory(factory);
    }

    @Override
    public Set<VerticleFactory> verticleFactories() {
        return this.deploymentManager.verticleFactories();
    }

    @Override
    public <T> void executeBlockingInternal(Action<T> action, Handler<AsyncResult<T>> resultHandler) {
        ContextImpl context = this.getOrCreateContext();
        context.executeBlocking(action, resultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<T>> asyncResultHandler) {
        ContextImpl context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, ordered, asyncResultHandler);
    }

    @Override
    public <T> void executeBlocking(Handler<Future<T>> blockingCodeHandler, Handler<AsyncResult<T>> asyncResultHandler) {
        this.executeBlocking(blockingCodeHandler, true, asyncResultHandler);
    }

    @Override
    public boolean isClustered() {
        return this.clusterManager != null;
    }

    @Override
    public EventLoopGroup nettyEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void simulateKill() {
        if (this.haManager() != null) {
            this.haManager().simulateKill();
        }
    }

    @Override
    public Deployment getDeployment(String deploymentID) {
        return this.deploymentManager.getDeployment(deploymentID);
    }

    @Override
    public synchronized void failoverCompleteHandler(FailoverCompleteHandler failoverCompleteHandler) {
        if (this.haManager() != null) {
            this.haManager().setFailoverCompleteHandler(failoverCompleteHandler);
        }
    }

    @Override
    public boolean isKilled() {
        return this.haManager().isKilled();
    }

    @Override
    public void failDuringFailover(boolean fail) {
        if (this.haManager() != null) {
            this.haManager().failDuringFailover(fail);
        }
    }

    @Override
    public VertxMetrics metricsSPI() {
        return this.metrics;
    }

    @Override
    public File resolveFile(String fileName) {
        return this.fileResolver.resolveFile(fileName);
    }

    @Override
    public void resolveAddress(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        this.addressResolver.resolveHostname(hostname, resultHandler);
    }

    @Override
    public AddressResolver addressResolver() {
        return this.addressResolver;
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.addressResolver.nettyAddressResolverGroup();
    }

    private void deleteCacheDirAndShutdown(final Handler<AsyncResult<Void>> completionHandler) {
        this.fileResolver.close(res -> {
            this.workerPool.close();
            this.internalBlockingPool.close();
            new ArrayList<SharedWorkerPool>(this.namedWorkerPools.values()).forEach(WorkerPool::close);
            this.acceptorEventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                    if (!future.isSuccess()) {
                        log.warn((Object)"Failure in shutting down acceptor event loop group", future.cause());
                    }
                    VertxImpl.this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                        public void operationComplete(io.netty.util.concurrent.Future future) throws Exception {
                            if (!future.isSuccess()) {
                                log.warn((Object)"Failure in shutting down event loop group", future.cause());
                            }
                            if (VertxImpl.this.metrics != null) {
                                VertxImpl.this.metrics.close();
                            }
                            VertxImpl.this.checker.close();
                            if (completionHandler != null) {
                                VertxImpl.this.eventLoopThreadFactory.newThread(() -> completionHandler.handle(Future.succeededFuture())).start();
                            }
                        }
                    });
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HAManager haManager() {
        if (this.haManager == null && this.haEnabled) {
            VertxImpl vertxImpl = this;
            synchronized (vertxImpl) {
                return this.haManager;
            }
        }
        return this.haManager;
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name) {
        return this.createSharedWorkerExecutor(name, this.defaultWorkerPoolSize);
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize) {
        return this.createSharedWorkerExecutor(name, poolSize, this.defaultWorkerMaxExecTime);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        if (maxExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        SharedWorkerPool sharedWorkerPool = this.namedWorkerPools.get(name);
        if (sharedWorkerPool == null) {
            ExecutorService workerExec = Executors.newFixedThreadPool(poolSize, new VertxThreadFactory(name + "-", this.checker, true, maxExecuteTime));
            PoolMetrics<?> workerMetrics = this.metrics != null ? this.metrics.createMetrics(workerExec, "worker", name, poolSize) : null;
            sharedWorkerPool = new SharedWorkerPool(name, workerExec, workerMetrics);
            this.namedWorkerPools.put(name, sharedWorkerPool);
        } else {
            sharedWorkerPool.refCount++;
        }
        ContextImpl context = this.getOrCreateContext();
        WorkerExecutorImpl namedExec = new WorkerExecutorImpl(this, sharedWorkerPool, true);
        context.addCloseHook(namedExec);
        return namedExec;
    }

    synchronized void releaseWorkerExecutor(String name) {
        this.namedWorkerPools.remove(name);
    }

    @Override
    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        this.closeHooks.add(hook);
    }

    @Override
    public void removeCloseHook(Closeable hook) {
        this.closeHooks.remove(hook);
    }

    static {
        ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        System.setProperty("io.netty.noJdkZlibDecoder", "false");
    }

    class SharedWorkerPool
    extends WorkerPool {
        private final String name;
        private int refCount;

        SharedWorkerPool(String name, ExecutorService workerExec, PoolMetrics workerMetrics) {
            super(workerExec, workerMetrics);
            this.refCount = 1;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (this.refCount > 0) {
                    this.refCount = 0;
                    super.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (--this.refCount == 0) {
                    VertxImpl.this.releaseWorkerExecutor(this.name);
                    super.close();
                }
            }
        }
    }

    private class TimeoutStreamImpl
    implements TimeoutStream,
    Handler<Long> {
        private final long delay;
        private final boolean periodic;
        private boolean paused;
        private Long id;
        private Handler<Long> handler;
        private Handler<Void> endHandler;

        public TimeoutStreamImpl(long delay, boolean periodic) {
            this.delay = delay;
            this.periodic = periodic;
        }

        @Override
        public synchronized void handle(Long event) {
            try {
                if (!this.paused) {
                    this.handler.handle(event);
                }
            }
            finally {
                if (!this.periodic && this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }

        @Override
        public TimeoutStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        @Override
        public void cancel() {
            if (this.id != null) {
                VertxImpl.this.cancelTimer(this.id);
            }
        }

        @Override
        public synchronized TimeoutStream handler(Handler<Long> handler) {
            if (handler != null) {
                if (this.id != null) {
                    throw new IllegalStateException();
                }
                this.handler = handler;
                this.id = VertxImpl.this.scheduleTimeout(VertxImpl.this.getOrCreateContext(), this, this.delay, this.periodic);
            } else {
                this.cancel();
            }
            return this;
        }

        @Override
        public synchronized TimeoutStream pause() {
            this.paused = true;
            return this;
        }

        @Override
        public synchronized TimeoutStream resume() {
            this.paused = false;
            return this;
        }

        @Override
        public synchronized TimeoutStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }
    }

    private class InternalTimerHandler
    implements Handler<Void>,
    Closeable {
        final Handler<Long> handler;
        final boolean periodic;
        final long timerID;
        final ContextImpl context;
        final java.util.concurrent.Future<?> future;
        final AtomicBoolean cancelled;

        boolean cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                if (VertxImpl.this.metrics != null) {
                    VertxImpl.this.metrics.timerEnded(this.timerID, true);
                }
                this.future.cancel(false);
                return true;
            }
            return false;
        }

        InternalTimerHandler(long timerID, Handler<Long> runnable, boolean periodic, long delay, ContextImpl context) {
            this.context = context;
            this.timerID = timerID;
            this.handler = runnable;
            this.periodic = periodic;
            this.cancelled = new AtomicBoolean();
            EventLoop el = context.nettyEventLoop();
            Runnable toRun = () -> context.runOnContext(this);
            this.future = periodic ? el.scheduleAtFixedRate(toRun, delay, delay, TimeUnit.MILLISECONDS) : el.schedule(toRun, delay, TimeUnit.MILLISECONDS);
            if (VertxImpl.this.metrics != null) {
                VertxImpl.this.metrics.timerCreated(timerID);
            }
        }

        @Override
        public void handle(Void v) {
            if (!this.cancelled.get()) {
                try {
                    this.handler.handle(this.timerID);
                }
                finally {
                    if (!this.periodic) {
                        this.cleanupNonPeriodic();
                    }
                }
            }
        }

        private void cleanupNonPeriodic() {
            ContextImpl context;
            VertxImpl.this.timeouts.remove(this.timerID);
            if (VertxImpl.this.metrics != null) {
                VertxImpl.this.metrics.timerEnded(this.timerID, false);
            }
            if ((context = VertxImpl.this.getContext()) != null) {
                context.removeCloseHook(this);
            }
        }

        @Override
        public void close(Handler<AsyncResult<Void>> completionHandler) {
            VertxImpl.this.timeouts.remove(this.timerID);
            this.cancel();
            completionHandler.handle(Future.succeededFuture());
        }
    }
}

