/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.cloudevents;

import io.streamzi.cloudevents.CloudEvent;
import io.streamzi.cloudevents.impl.CloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;

public class CloudEventBuilder<T> {
    private String eventType;
    private String cloudEventsVersion = "0.1";
    private URI source;
    private String eventID;
    private String eventTypeVersion;
    private ZonedDateTime eventTime;
    private URI schemaURL;
    private String contentType;
    private Map extensions;
    private T data;

    public CloudEventBuilder<T> eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public CloudEventBuilder<T> eventTypeVersion(String eventTypeVersion) {
        this.eventTypeVersion = eventTypeVersion;
        return this;
    }

    public CloudEventBuilder<T> cloudEventsVersion(String cloudEventsVersion) {
        this.cloudEventsVersion = cloudEventsVersion;
        return this;
    }

    public CloudEventBuilder<T> source(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> eventID(String eventID) {
        this.eventID = eventID;
        return this;
    }

    public CloudEventBuilder<T> eventTime(ZonedDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public CloudEventBuilder<T> schemaURL(URI schemaURL) {
        this.schemaURL = schemaURL;
        return this;
    }

    public CloudEventBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CloudEventBuilder<T> extensions(Map extensions) {
        this.extensions = extensions;
        return this;
    }

    public CloudEventBuilder<T> data(T data) {
        this.data = data;
        return this;
    }

    public CloudEvent<T> build() {
        if (this.eventType == null || this.cloudEventsVersion == null || this.source == null || this.eventID == null) {
            throw new IllegalArgumentException("please provide all required fields");
        }
        return new CloudEventImpl<T>(this.eventType, this.cloudEventsVersion, this.source, this.eventID, this.eventTypeVersion, this.eventTime, this.schemaURL, this.contentType, this.extensions, this.data);
    }
}

