/*
 * Decompiled with CFR 0.152.
 */
package io.streamzi.cloudevents.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.streamzi.cloudevents.CloudEvent;
import io.streamzi.cloudevents.impl.ZonedDateTimeDeserializer;
import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class CloudEventImpl<T>
implements CloudEvent<T>,
Serializable {
    public static final String EVENT_TYPE_KEY = "eventType";
    public static final String CLOUD_EVENTS_VERSION_KEY = "cloudEventsVersion";
    public static final String SOURCE_KEY = "source";
    public static final String EVENT_ID_KEY = "eventID";
    public static final String EVENT_TYPE_VERSION_KEY = "eventTypeVersion";
    public static final String EVENT_TIME_KEY = "eventTime";
    public static final String SCHEMA_URL_KEY = "schemaURL";
    public static final String CONTENT_TYPE_KEY = "contentType";
    public static final String EXTENSIONS_KEY = "extensions";
    public static final String DATA_KEY = "data";
    private static final long serialVersionUID = 2L;
    private final Map<String, ? super Object> attributes = new HashMap<String, Object>();

    @JsonIgnore
    public Map<String, ? super Object> getAttributes() {
        return this.attributes;
    }

    public CloudEventImpl(String eventType, String cloudEventsVersion, URI source, String eventID, String eventTypeVersion, ZonedDateTime eventTime, URI schemaURL, String contentType, Map extensions, T data) {
        this.attributes.put(EVENT_TYPE_KEY, eventType);
        this.attributes.put(CLOUD_EVENTS_VERSION_KEY, cloudEventsVersion);
        this.attributes.put(SOURCE_KEY, source);
        this.attributes.put(EVENT_ID_KEY, eventID);
        this.attributes.put(EVENT_TYPE_VERSION_KEY, eventTypeVersion);
        this.attributes.put(EVENT_TIME_KEY, eventTime);
        this.attributes.put(SCHEMA_URL_KEY, schemaURL);
        if (extensions != null) {
            this.attributes.put(EXTENSIONS_KEY, extensions);
        } else {
            this.attributes.put(EXTENSIONS_KEY, new LinkedHashMap());
        }
        this.attributes.put(CONTENT_TYPE_KEY, contentType);
        this.attributes.put(DATA_KEY, data);
    }

    CloudEventImpl() {
    }

    @Override
    public String getEventType() {
        return (String)this.attributes.get(EVENT_TYPE_KEY);
    }

    @Override
    public String getCloudEventsVersion() {
        return (String)this.attributes.get(CLOUD_EVENTS_VERSION_KEY);
    }

    @Override
    public URI getSource() {
        return (URI)this.attributes.get(SOURCE_KEY);
    }

    @Override
    public String getEventID() {
        return (String)this.attributes.get(EVENT_ID_KEY);
    }

    @Override
    public Optional<String> getEventTypeVersion() {
        return Optional.ofNullable((String)this.attributes.get(EVENT_TYPE_VERSION_KEY));
    }

    @Override
    public Optional<ZonedDateTime> getEventTime() {
        return Optional.ofNullable((ZonedDateTime)this.attributes.get(EVENT_TIME_KEY));
    }

    @Override
    public Optional<URI> getSchemaURL() {
        return Optional.ofNullable((URI)this.attributes.get(SCHEMA_URL_KEY));
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable((String)this.attributes.get(CONTENT_TYPE_KEY));
    }

    @Override
    public Optional<Map> getExtensions() {
        return Optional.ofNullable((Map)this.attributes.get(EXTENSIONS_KEY));
    }

    @Override
    public Optional<T> getData() {
        return Optional.ofNullable(this.attributes.get(DATA_KEY));
    }

    void setEventType(String eventType) {
        this.attributes.put(EVENT_TYPE_KEY, eventType);
    }

    void setCloudEventsVersion(String cloudEventsVersion) {
        this.attributes.put(CLOUD_EVENTS_VERSION_KEY, cloudEventsVersion);
    }

    void setSource(URI source) {
        this.attributes.put(SOURCE_KEY, source);
    }

    void setEventID(String eventID) {
        this.attributes.put(EVENT_ID_KEY, eventID);
    }

    void setEventTypeVersion(String eventTypeVersion) {
        this.attributes.put(EVENT_TYPE_VERSION_KEY, eventTypeVersion);
    }

    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    void setEventTime(ZonedDateTime eventTime) {
        this.attributes.put(EVENT_TIME_KEY, eventTime);
    }

    void setSchemaURL(URI schemaURL) {
        this.attributes.put(SCHEMA_URL_KEY, schemaURL);
    }

    void setContentType(String contentType) {
        this.attributes.put(CONTENT_TYPE_KEY, contentType);
    }

    void setExtensions(Map extensions) {
        if (extensions != null) {
            this.attributes.put(EXTENSIONS_KEY, extensions);
        } else {
            this.attributes.put(EXTENSIONS_KEY, new LinkedHashMap());
        }
    }

    public void setData(T data) {
        this.attributes.put(DATA_KEY, data);
    }

    public String toString() {
        return "CloudEventImpl{" + this.attributes + '}';
    }
}

